/*
 * Decompiled with CFR 0.152.
 */
package com.jamierf.wol;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class WakeOnLan {
    private static final String BROADCAST_ADDRESS = "255.255.255.255";
    private static final int WOL_PORT = 9;

    public static void wake(String mac) throws IOException, DecoderException {
        WakeOnLan.wake(mac, 9);
    }

    public static void wake(String mac, int port) throws IOException, DecoderException {
        byte[] address = Hex.decodeHex((char[])mac.replaceAll("[\\-:]", "").toCharArray());
        byte[] payload = WakeOnLan.buildPayload(address);
        InetSocketAddress destination = new InetSocketAddress(BROADCAST_ADDRESS, port);
        DatagramPacket packet = new DatagramPacket(payload, payload.length, destination);
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setBroadcast(true);
            socket.send(packet);
        }
    }

    private static byte[] buildPayload(byte[] address) {
        ByteBuffer packet = ByteBuffer.wrap(new byte[6 + 16 * address.length]);
        for (int i = 0; i < 6; ++i) {
            packet.put((byte)-1);
        }
        while (packet.remaining() >= address.length) {
            packet.put(address);
        }
        return packet.array();
    }

    private WakeOnLan() {
    }
}

