/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.SerializablePredicate;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.springframework.context.ApplicationContext;

public class AvailablePackageListMasterDetailsPresenter
extends PackageListMasterDetailsPresenter {
    public AvailablePackageListMasterDetailsPresenter(PackageListMasterDetailsPresenter.View view, Consumer<Collection<Package>> detailsPresenter, PackageManager packageManager, ClientService clientService, ApplicationContext applicationContext) {
        super(view, detailsPresenter, packageManager, clientService, applicationContext);
        view.getPackageFilerCheckbox().setVisible(true);
    }

    @Override
    protected void applyFilters() {
        super.applyFilters();
        Boolean showAllVersions = this.view.getPackageFilerCheckbox().getValue();
        if (!showAllVersions.booleanValue()) {
            this.dataProvider.addFilter((SerializablePredicate)new NotInstalledFilter(this.packageManager));
            this.dataProvider.addFilter((SerializablePredicate)new PackageListMasterDetailsPresenter.LatestVersionOnlyFilter((ListDataProvider<AbstractPackageItem>)this.dataProvider));
        }
    }

    public static class NotInstalledFilter
    implements SerializablePredicate<AbstractPackageItem> {
        private final Collection<String> installedPackageNames;

        public NotInstalledFilter(PackageManager packageManager) {
            this.installedPackageNames = packageManager.getInstalledPackages().stream().map(Package::getName).collect(Collectors.toList());
        }

        public boolean test(AbstractPackageItem item) {
            return !this.installedPackageNames.contains(item.getName());
        }
    }
}

