/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.event.selection.SelectionEvent;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.exception.SourceIntegrityViolationException;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.web.component.NotificationDialog;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.StringToUrlConverter;
import org.openthinclient.web.progress.ProgressReceiverDialog;
import org.openthinclient.web.ui.event.PackageManagerTaskActivatedEvent;
import org.openthinclient.web.ui.event.PackageManagerTaskFinalizedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.dialogs.ConfirmDialog;
import org.vaadin.spring.events.Event;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;

public class SourcesListPresenter {
    private static final Logger LOG = LoggerFactory.getLogger(SourcesListPresenter.class);
    private final View view;
    private final Binder<Source> sourceFormBinder;
    private PackageManager packageManager;
    private final IMessageConveyor mc;

    public SourcesListPresenter(View view) {
        this.view = view;
        this.sourceFormBinder = new Binder();
        this.sourceFormBinder.setBean((Object)new Source());
        this.sourceFormBinder.forField((HasValue)view.getURLTextField()).withConverter((Converter)new StringToUrlConverter()).bind(Source::getUrl, Source::setUrl);
        this.sourceFormBinder.forField((HasValue)view.getDescriptionTextArea()).bind(Source::getDescription, Source::setDescription);
        this.sourceFormBinder.forField((HasValue)view.getEnabledCheckBox()).bind(Source::isEnabled, Source::setEnabled);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.view.getUpdateButton().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_UPDATE_CAPTION, new Object[0]));
        this.view.getSaveSourceButton().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_SAVE_CAPTION, new Object[0]));
        this.view.getAddSourceButton().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_ADD_CAPTION, new Object[0]));
        this.view.getDeleteSourceButton().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_DELETE_CAPTION, new Object[0]));
        this.view.getURLTextField().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_URLTEXTFIELD_CAPTION, new Object[0]));
        this.view.getEnabledCheckBox().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_ENABLECHECKBOX_CAPTION, new Object[0]));
        this.view.getDescriptionTextArea().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_DESCIPRIONTEXT_CAPTION, new Object[0]));
        Label sourceListCaption = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_SOURCELIST_CAPTION, new Object[0]));
        sourceListCaption.setStyleName("h3");
        this.view.getSourcesListLayout().replaceComponent((Component)this.view.getSourcesLabel(), (Component)sourceListCaption);
        Label sourceDetailsCaption = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_DETAILS_CAPTION, new Object[0]));
        sourceDetailsCaption.setStyleName("h3");
        this.view.getSourceDetailsLayout().replaceComponent((Component)this.view.getSourceDetailsLabel(), (Component)sourceDetailsCaption);
        this.view.getSourcesTable().addSelectionListener(this::sourcesListValueChanged);
        this.view.getSaveSourceButton().addClickListener(this::saveSourcesClicked);
        this.view.getAddSourceButton().addClickListener(this::addSourceClicked);
        this.view.getDeleteSourceButton().addClickListener(this::removeSourceClicked);
        this.view.getUpdateButton().addClickListener(this::updateSourcesClicked);
        this.view.getDeleteSourceButton().setEnabled(false);
    }

    private void updateSourcesClicked(Button.ClickEvent clickEvent) {
        this.updatePackages();
    }

    private void updatePackages() {
        ListenableProgressFuture update = this.packageManager.updateCacheDB();
        ProgressReceiverDialog dialog = new ProgressReceiverDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_PROGRESS_CAPTION, new Object[0]));
        dialog.watch(update);
        dialog.open(true);
    }

    private void deletePackages(Source source) {
        ListenableProgressFuture update = this.packageManager.deleteSourcePackagesFromCacheDB(source);
        update.addCallback(success -> this.removeSource(source), error -> this.showSourceNotDeletedError());
        ProgressReceiverDialog dialog = new ProgressReceiverDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_PROGRESS_CAPTION, new Object[0]));
        dialog.watch(update);
        dialog.open(true);
    }

    private void removeSource(Source source) {
        try {
            this.packageManager.deleteSource(source);
            this.view.getSourcesTable().setItems(this.packageManager.findAllSources());
        }
        catch (SourceIntegrityViolationException exception) {
            LOG.error("Cannot delete selected source.", (Throwable)exception);
            this.showSourceNotDeletedError();
            return;
        }
    }

    private void showSourceNotDeletedError() {
        NotificationDialog notification = new NotificationDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_NOTDELETED_CAPTION, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_NOTDELETED_DESCRIPTION, new Object[0]), NotificationDialog.NotificationDialogType.ERROR);
        notification.open(false);
    }

    private void removeSourceClicked(Button.ClickEvent clickEvent) {
        ConfirmDialog.show((UI)UI.getCurrent(), (String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_DELETE_CAPTION, new Object[0]), (String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_DELETE_DESCRIPTION, new Object[0]), (String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_YES, new Object[0]), (String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_NO, new Object[0]), () -> {
            Source source = this.view.getSelectedSource();
            if (source.getId() == null) {
                this.view.getSourcesTable().setItems(this.packageManager.findAllSources());
                return;
            }
            this.deletePackages(source);
        });
    }

    private void addSourceClicked(Button.ClickEvent clickEvent) {
        Source newSource = new Source();
        try {
            newSource.setUrl(new URL("http://archive.openthinclient.org/openthinclient/v2020/packages/"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        newSource.setEnabled(true);
        newSource.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_FORM_DESCRIPTION, new Object[0]));
        Collection sources = this.packageManager.findAllSources();
        sources.add(newSource);
        this.view.getSourcesTable().setItems(sources);
        this.view.getSourcesTable().select((Object)newSource);
    }

    private void saveSourcesClicked(Button.ClickEvent clickEvent) {
        BinderValidationStatus validationStatus = this.sourceFormBinder.validate();
        if (validationStatus.hasErrors()) {
            return;
        }
        this.sourceFormBinder.writeBeanIfValid((Object)this.view.getSelectedSource());
        Source source = this.view.getSelectedSource();
        this.packageManager.saveSource(source);
        NotificationDialog notification = new NotificationDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_SAVE_CAPTION, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_NOTIFICATION_SAVE_DESCRIPTION, new Object[0]), NotificationDialog.NotificationDialogType.SUCCESS);
        notification.addCloseListener((Button.ClickListener & Serializable)e -> this.updatePackages());
        notification.open(false);
        this.updateSources();
    }

    private void sourcesListValueChanged(SelectionEvent<Source> sourceSelectionEvent) {
        Optional selectedItem = sourceSelectionEvent.getFirstSelectedItem();
        if (selectedItem.isPresent()) {
            this.sourceSelected((Source)selectedItem.get());
        } else {
            this.sourceFormBinder.setBean((Object)new Source());
        }
        this.view.getDeleteSourceButton().setEnabled(selectedItem.isPresent());
    }

    private void sourceSelected(Source source) {
        if (source == null) {
            this.sourceFormBinder.setBean((Object)new Source());
        } else {
            this.sourceFormBinder.setBean((Object)source);
            this.view.getURLTextField().setEnabled(source.getLastUpdated() == null);
        }
    }

    public void setPackageManager(PackageManager packageManager) {
        this.packageManager = packageManager;
        this.updateSources();
    }

    private void updateSources() {
        this.view.getSourcesTable().setItems(this.packageManager.findAllSources());
    }

    @EventBusListenerMethod
    public void onPackageManagerTaskActivated(Event<PackageManagerTaskActivatedEvent> event) {
    }

    @EventBusListenerMethod
    public void onPackageManagerTaskFinalized(Event<PackageManagerTaskFinalizedEvent> event) {
    }

    public static interface View {
        public Button getUpdateButton();

        public Button getAddSourceButton();

        public Button getDeleteSourceButton();

        public Button getSaveSourceButton();

        public TextField getURLTextField();

        public CheckBox getEnabledCheckBox();

        public TextArea getDescriptionTextArea();

        public Grid<Source> getSourcesTable();

        public Source getSelectedSource();

        public Label getSourceDetailsLabel();

        public Label getSourcesLabel();

        public HorizontalLayout getSourcesListLayout();

        public VerticalLayout getSourceDetailsLayout();

        public void disableForm();
    }
}

