/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.sidebar;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

public class OTCSideBarUtils
extends SideBarUtils {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    ApplicationContext applicationContext;
    Map<String, Class> nameTypeMap = new HashMap<String, Class>();

    public OTCSideBarUtils(ApplicationContext applicationContext, I18N i18n) {
        super(applicationContext, i18n);
        this.applicationContext = applicationContext;
        this.scanForBeans();
    }

    private void scanForBeans() {
        String[] beanNames;
        this.logger.debug("Scanning for side bar items");
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(SideBarItem.class)) {
            this.logger.debug("Bean [{}] declares a side bar item", (Object)beanName);
            Class beanType = this.applicationContext.getType(beanName);
            this.nameTypeMap.put(beanName, beanType);
        }
    }

    public Map<String, Class> getNameTypeMap() {
        return this.nameTypeMap;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

