/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.openthinclient.service.update.UpdateChecker;
import org.openthinclient.service.update.UpdateCheckerEvent;
import org.openthinclient.service.update.UpdateRunner;
import org.openthinclient.service.update.UpdateRunnerEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.SettingsUI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="support", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_APPLICATION_HEADER", order=70)
public class UpdateManagerView
extends Panel
implements View {
    public static final String NAME = "support";
    private static final long serialVersionUID = -8836300902351197949L;
    @Autowired
    private UpdateChecker updateChecker;
    @Autowired
    private UpdateRunner updateRunner;
    @Value(value="${application.version}")
    private String applicationVersion;
    private EventBus eventBus;
    private MessageConveyor mc;
    private CssLayout root;
    private Button updateCheckerButton = null;
    private Label updateCheckerButtonLabel = null;
    private Label newVersionLabel = null;
    private CssLayout updateRunnerContainer = null;
    private Button updateRunnerButton = null;
    private Label updateRunnerButtonLabel = null;
    private UI ui;

    public UpdateManagerView(EventBus.SessionEventBus eventBus) {
        this.eventBus = eventBus;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setSizeFull();
        this.root = new CssLayout();
        this.root.setStyleName("updateview");
        this.setContent((Component)this.root);
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.ui = UI.getCurrent();
        Label versionInformation = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CURRENT_APPLICATION_VERSION, new Object[]{this.applicationVersion}));
        versionInformation.addStyleName("versionInformation");
        this.newVersionLabel = new Label();
        this.updateNewVersionLabel();
        this.root.addComponents(new Component[]{versionInformation, this.newVersionLabel, this.buildUpdateChecker(), this.buildUpdateRunner(), this.buildWikilinks()});
    }

    private void updateNewVersionLabel() {
        if (this.updateChecker.getNewVersion().isPresent()) {
            this.newVersionLabel.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_UPDATE, new Object[]{this.updateChecker.getNewVersion().get()}));
            this.newVersionLabel.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
        } else {
            this.newVersionLabel.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_OK, new Object[0]));
            this.newVersionLabel.setIcon((Resource)VaadinIcons.CHECK);
        }
    }

    private CssLayout buildUpdateChecker() {
        CssLayout updateCheckerContainer = new CssLayout();
        updateCheckerContainer.addStyleName("update-checker");
        this.updateCheckerButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_BUTTON, new Object[0]));
        this.updateCheckerButtonLabel = new Label();
        updateCheckerContainer.addComponents(new Component[]{this.updateCheckerButton, this.updateCheckerButtonLabel});
        if (this.updateChecker.isRunning()) {
            this.displayUpdateCheckerRunning();
        }
        this.updateCheckerButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.displayUpdateCheckerRunning();
            this.updateChecker.fetchNewVersion();
        });
        return updateCheckerContainer;
    }

    private void displayUpdateCheckerRunning() {
        this.updateCheckerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_RUNNING, new Object[0]));
        this.updateCheckerButton.setEnabled(false);
    }

    private CssLayout buildUpdateRunner() {
        this.updateRunnerContainer = new CssLayout();
        this.updateRunnerContainer.addStyleName("update-runner");
        this.updateRunnerButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_BUTTON, new Object[0]));
        this.updateRunnerButtonLabel = new Label();
        Label description = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_DESCRIPTION, new Object[0]));
        description.addStyleName("description");
        this.updateRunnerContainer.addComponents(new Component[]{this.updateRunnerButton, this.updateRunnerButtonLabel, description});
        this.updateRunnerContainer.setVisible(this.updateChecker.getNewVersion().isPresent());
        if (this.updateRunner.isRunning()) {
            this.displayUpdateRunnerRunning();
        }
        this.updateRunnerButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.displayUpdateRunnerRunning();
            this.updateRunner.run();
        });
        return this.updateRunnerContainer;
    }

    private void displayUpdateRunnerRunning() {
        this.updateRunnerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_RUNNING, new Object[0]));
        this.updateRunnerButton.setEnabled(false);
    }

    private CssLayout buildWikilinks() {
        CssLayout wikilinks = new CssLayout();
        wikilinks.addComponents(new Component[]{new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_WIKI_CAPTION, new Object[0])), new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_WIKI_VERSION_INFORMATION, new Object[0]), ContentMode.HTML), new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_WIKI_ROADMAP, new Object[0]), ContentMode.HTML)});
        wikilinks.addStyleName("wikilinks");
        return wikilinks;
    }

    @EventBusListenerMethod
    private void updateCheckerFinished(UpdateCheckerEvent event) {
        this.updateCheckerButton.setEnabled(true);
        if (event.failed()) {
            this.updateCheckerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_FAIL, new Object[0]));
        } else {
            Optional newVersion = this.updateChecker.getNewVersion();
            if (newVersion.isPresent()) {
                this.updateCheckerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_UPDATE, new Object[]{newVersion.get()}));
            } else {
                this.updateCheckerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_NOUPDATE, new Object[0]));
            }
            this.updateNewVersionLabel();
            this.updateRunnerContainer.setVisible(newVersion.isPresent());
        }
        this.ui.push();
    }

    @EventBusListenerMethod
    private void updateRunnerFinished(UpdateRunnerEvent event) {
        if (event.failed()) {
            this.updateRunnerButton.setEnabled(true);
            if (event.getExitValue() == 107) {
                this.updateRunnerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_NONE, new Object[0]));
            } else {
                this.updateRunnerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_ERROR, new Object[0]));
            }
        } else {
            this.updateRunnerButtonLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_INSTALLING, new Object[0]));
        }
        this.ui.push();
    }
}

