/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.navigator.ViewChangeListener;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.events.EventBus;

public abstract class AbstractThinclientGroupView
extends AbstractThinclientView {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public AbstractThinclientGroupView(ConsoleWebMessages i18nTitleKey, EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(i18nTitleKey, eventBus, notificationService);
    }

    public void saveValues(DirectoryObjectPanelPresenter profilePanelPresenter, DirectoryObject profile) {
        this.LOGGER.info("Save values for group: " + profile);
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            String current;
            ItemConfiguration bean = otcProperty.getConfiguration();
            String propertyKey = otcProperty.getKey();
            String org = null;
            if (propertyKey.equals("name")) {
                org = profile.getName();
            } else if (propertyKey.equals("description")) {
                org = profile.getDescription();
            } else {
                this.LOGGER.warn("Unexpected key {} for group {} will be ignored!", (Object)propertyKey, (Object)profile.getClass().getName());
            }
            String string = current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
            if (current != null && !StringUtils.equals((CharSequence)org, (CharSequence)current)) {
                switch (propertyKey) {
                    case "name": {
                        profile.setName(current);
                        break;
                    }
                    case "description": {
                        profile.setDescription(current);
                    }
                }
            } else if (propertyKey.equals("description")) {
                this.LOGGER.info(" Apply null value for description");
                profile.setDescription(null);
            }
        }));
        boolean success = this.saveProfile(profile, profilePanelPresenter);
        if (success) {
            this.selectItem(profile);
            this.navigateTo(profile);
        }
    }

    public void showProfileMetadata(DirectoryObject directoryObject) {
        this.showProfileMetadataPanel(this.createProfilePanel(directoryObject, true));
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) {
        return this.createProfilePanel(directoryObject, false);
    }

    public ProfilePanel createProfilePanel(DirectoryObject directoryObject, boolean isNew) {
        String title = isNew ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_GROUP_HEADER, new Object[0]) : directoryObject.getName();
        ProfilePanel profilePanel = new ProfilePanel(title, directoryObject.getClass());
        DirectoryObjectPanelPresenter presenter = new DirectoryObjectPanelPresenter(this, profilePanel, directoryObject);
        OtcPropertyGroup propertyGroup = this.createMetadataPropertyGroup(directoryObject, isNew);
        presenter.setItemGroups(Arrays.asList(propertyGroup, new OtcPropertyGroup()));
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, directoryObject));
        if (isNew) {
            presenter.hideCopyButton();
            presenter.hideDeleteButton();
        }
        return profilePanel;
    }

    protected OtcPropertyGroup createMetadataPropertyGroup(DirectoryObject directoryObject, boolean isNew) {
        OtcPropertyGroup group = this.builder.createDirectoryObjectMetaDataGroup(directoryObject);
        if (isNew) {
            this.addProfileNameAlreadyExistsValidator(group);
        }
        return group;
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.LOGGER.debug("enter -> source={}, navigator-state=", event.getSource(), (Object)event.getNavigator().getState());
        String[] params = Optional.ofNullable(event.getParameters()).orElse("").split("/", 2);
        if (params.length > 0) {
            if ("create".equals(params[0])) {
                switch (event.getViewName()) {
                    case "applicationgroup_view": {
                        this.showProfileMetadata((DirectoryObject)new ApplicationGroup());
                        break;
                    }
                    case "usergroup_view": {
                        this.showProfileMetadata((DirectoryObject)new UserGroup());
                    }
                }
            } else if ("edit".equals(params[0]) && params.length == 2 && params[1].length() > 0) {
                Object profile = this.getFreshProfile(params[1]);
                if (profile != null) {
                    this.showProfile((DirectoryObject)profile);
                } else {
                    this.LOGGER.info("No profile found for name '" + params[1] + "'.");
                }
            } else {
                this.showOverview();
            }
        }
    }
}

