/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.ui.UI;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencesComponentPresenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePanelPresenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencePanelPresenter.class);
    protected ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();
    private ProfileReferencesPanel view;
    private IMessageConveyor mc;

    public ReferencePanelPresenter(ProfileReferencesPanel view) {
        this.view = view;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    public void showReference(Set<? extends DirectoryObject> members, String title, Set<? extends DirectoryObject> allObjects, Class clazz, Consumer<List<Item>> profileReferenceChangeConsumer) {
        this.showReference(members, title, allObjects, clazz, profileReferenceChangeConsumer, null, false);
    }

    public void showReference(Set<? extends DirectoryObject> members, String title, Set<? extends DirectoryObject> allObjects, Class clazz, Consumer<List<Item>> profileReferenceChangeConsumer, Function<Item, List<Item>> memberSupplier, boolean isReadOnly) {
        List<Item> memberItems = ProfilePropertiesBuilder.createFilteredItemsFromDO(members, clazz);
        ReferencesComponentPresenter presenter = this.view.addReferences(title, ProfilePropertiesBuilder.createItems(allObjects), memberItems, memberSupplier, isReadOnly);
        presenter.setProfileReferenceChangedConsumer(profileReferenceChangeConsumer);
    }

    public void showDeviceAssociations(Set<Device> all, Set<? extends DirectoryObject> members, Consumer<List<Item>> profileReferenceChangeConsumer) {
        List<Item> allDevices = ProfilePropertiesBuilder.createItems(all);
        List<Item> deviceMembers = ProfilePropertiesBuilder.createFilteredItemsFromDO(members, Device.class);
        ReferencesComponentPresenter presenter = this.view.addReferences(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICE_HEADER, new Object[0]), allDevices, deviceMembers, null, false);
        presenter.setProfileReferenceChangedConsumer(profileReferenceChangeConsumer);
    }
}

