/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIPAddressFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIPAddressFinder.class);
    private static final Pattern IPADDRESS_PATTERN = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\s");
    private static String fileName = "/logs/syslog.log";

    public static Optional<String> findIPAddress(String macAddress, File managerHome) {
        try {
            String line;
            ReversedLinesFileReader br = new ReversedLinesFileReader(Paths.get(managerHome.toPath().toAbsolutePath().toString(), fileName).toFile(), StandardCharsets.UTF_8);
            while ((line = br.readLine()) != null) {
                Matcher matcher;
                if (!line.contains(macAddress) || !(matcher = IPADDRESS_PATTERN.matcher(line)).find()) continue;
                String group = matcher.group().trim();
                LOGGER.debug("Found IP {}\u00a0for mac {}", (Object)group, (Object)macAddress);
                return Optional.of(group);
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot read " + fileName + " in " + managerHome.toPath(), (Throwable)e);
        }
        LOGGER.debug("No IP found\u00a0for mac {}", (Object)macAddress);
        return Optional.empty();
    }
}

