/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Setter;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.i18n.ConsoleWebMessages;

public class UserProfileSubWindow
extends Window {
    private static final long serialVersionUID = -6L;
    IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    UserService service;
    boolean validatePassword = false;

    public UserProfileSubWindow(UserService service) {
        this.service = service;
        this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
    }

    public void refresh(User user) {
        String userName = user.getName();
        this.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SETTINGS_ADMIN_WINDOWTITLE, new Object[]{userName}));
        this.setHeight("400px");
        this.setWidth("500px");
        this.center();
        VerticalLayout subContent = new VerticalLayout();
        subContent.setSizeFull();
        this.setContent((Component)subContent);
        FormLayout layoutWithBinder = new FormLayout();
        Binder binder = new Binder();
        Label infoLabel = new Label();
        TextField name = new TextField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_NAME_LABEL, new Object[0]));
        name.setValueChangeMode(ValueChangeMode.EAGER);
        TextField description = new TextField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]));
        description.setValueChangeMode(ValueChangeMode.EAGER);
        final PasswordField passwordField = new PasswordField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_LABEL, new Object[0]));
        passwordField.setValueChangeMode(ValueChangeMode.EAGER);
        PasswordField passwordRetype = new PasswordField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_RETYPE_LABEL, new Object[0]));
        passwordRetype.setValueChangeMode(ValueChangeMode.EAGER);
        NativeButton save = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]));
        NativeButton reset = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_RESET, new Object[0]));
        layoutWithBinder.addComponent((Component)name);
        layoutWithBinder.addComponent((Component)description);
        layoutWithBinder.addComponent((Component)passwordField);
        layoutWithBinder.addComponent((Component)passwordRetype);
        HorizontalLayout actions = new HorizontalLayout();
        actions.addComponents(new Component[]{save, reset});
        name.setRequiredIndicatorVisible(true);
        description.setRequiredIndicatorVisible(true);
        binder.setBean((Object)user);
        binder.forField((HasValue)name).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_LENGTH, new Object[0]), Integer.valueOf(5), Integer.valueOf(15))).bind(DirectoryObject::getName, DirectoryObject::setName);
        binder.forField((HasValue)description).bind(DirectoryObject::getDescription, DirectoryObject::setDescription);
        binder.forField((HasValue)passwordField).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_VALIDATOR_LENGTH, new Object[0]), Integer.valueOf(1), null)).bind((ValueProvider & Serializable)directoryObject1 -> new String(directoryObject1.getUserPassword()), (Setter & Serializable)(u, s) -> {
            if (this.isValidatePassword()) {
                u.setNewPassword(s);
            }
        }).getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.setPasswordChanged(true);
            infoLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_CHANGE_PASSWORD_HINT, new Object[0]));
        });
        binder.forField((HasValue)passwordRetype).withNullRepresentation((Object)"").withValidator((Validator)new AbstractValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_RETYPE_VALIDATOR, new Object[0])){

            public ValidationResult apply(Object value, ValueContext context) {
                if (UserProfileSubWindow.this.isValidatePassword()) {
                    return this.toResult(value, passwordField.getValue() != null && passwordField.getValue().equals(value));
                }
                return ValidationResult.ok();
            }

            public Object apply(Object o, Object o2) {
                return null;
            }
        }).bind((ValueProvider & Serializable)u -> new String(((User)u).getUserPassword()), (Setter & Serializable)(u, s) -> {
            if (this.isValidatePassword()) {
                ((User)u).setVerifyPassword((String)s);
            }
        }).getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.setPasswordChanged(true));
        save.addClickListener((Button.ClickListener & Serializable)event -> {
            if (binder.writeBeanIfValid((Object)user)) {
                user.getRealm().setNeedsRefresh();
                this.service.save((DirectoryObject)user);
                user.getRealm().fakePropertyChange();
                super.close();
            } else {
                BinderValidationStatus validate = binder.validate();
                String errorText = validate.getFieldValidationStatuses().stream().filter(BindingValidationStatus::isError).map(BindingValidationStatus::getMessage).map(Optional::get).distinct().collect(Collectors.joining(", "));
                infoLabel.setValue("There are errors: " + errorText);
            }
        });
        reset.addClickListener((Button.ClickListener & Serializable)event -> {
            binder.readBean((Object)this.service.findByName(userName));
            infoLabel.setValue("");
        });
        VerticalLayout vl = new VerticalLayout();
        vl.setSpacing(false);
        vl.setMargin(false);
        vl.addComponents(new Component[]{layoutWithBinder, infoLabel, actions});
        subContent.addComponent((Component)vl);
    }

    public boolean isValidatePassword() {
        return this.validatePassword;
    }

    public void setPasswordChanged(boolean validatePassword) {
        this.validatePassword = validatePassword;
    }

    public void showError(Exception e) {
        String message = e.getCause() instanceof DirectoryException ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_ERROR_DIRECTORY_EXCEPTION, new Object[0]) : e.getLocalizedMessage();
        Label emptyScreenHint = new Label(VaadinIcons.WARNING.getHtml() + "&nbsp;&nbsp;&nbsp;" + this.mc.getMessage((Enum)ConsoleWebMessages.UI_UNEXPECTED_ERROR, new Object[0]) + message, ContentMode.HTML);
        emptyScreenHint.setStyleName("errorScreenHint");
        this.setContent((Component)emptyScreenHint);
    }
}

