/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.mountd;

import java.io.File;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.mountd.Exporter;
import org.openthinclient.service.nfs.NFSExport;

public class DefaultExporter
implements Exporter {
    @Override
    public NFSExport getExport(InetAddress peer, String mountRequest) {
        String lowerCaseMountRequest = mountRequest.toLowerCase();
        Optional<NFSExport> nfsExport = Stream.of(File.listRoots()).filter(root -> root.getAbsolutePath().toLowerCase().startsWith(lowerCaseMountRequest)).findFirst().map(this::createExport);
        return nfsExport.orElse(null);
    }

    private NFSExport createExport(File root) {
        NFSExport export = new NFSExport();
        export.setName(root.getAbsolutePath());
        export.setRoot(root);
        return export;
    }

    @Override
    public List<NFSExport> getExports() {
        return Stream.of(File.listRoots()).map(this::createExport).collect(Collectors.toList());
    }
}

