/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.nfsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openthinclient.nfsd.NFSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(CacheCleaner.class);
    private static final BlockingQueue<NFSFile> taintQueue = new LinkedBlockingQueue<NFSFile>();
    private static final Janitor janitor = new Janitor(taintQueue);

    public static void registerDirtyFile(NFSFile file) {
        if (null != file && file.isChannelOpen()) {
            taintQueue.offer(file);
        }
    }

    private static class Janitor
    implements Runnable {
        private final BlockingQueue<NFSFile> taintQueue;
        private final Set<NFSFile> dirtyFilesSet = new HashSet<NFSFile>();
        private final Set<NFSFile> openFilesSet = new HashSet<NFSFile>();
        private boolean shutdownRequested;
        private static long EXPIRY_INTERVAL = 5000L;
        private static final int MAX_OPEN_FILES = 256;

        public Janitor(BlockingQueue<NFSFile> taintQueue) {
            this.taintQueue = taintQueue;
            Thread t = new Thread((Runnable)this, "CacheCleaner");
            t.setDaemon(true);
            t.setPriority(4);
            t.start();
        }

        @Override
        public void run() {
            while (!this.shutdownRequested) {
                try {
                    NFSFile file = this.taintQueue.poll(EXPIRY_INTERVAL, TimeUnit.MILLISECONDS);
                    if (null != file) {
                        this.dirtyFilesSet.add(file);
                        if (!file.isChannelOpen()) continue;
                        this.openFilesSet.add(file);
                        if (this.openFilesSet.size() < 256) continue;
                        this.watermarkCacheFlush();
                        continue;
                    }
                    this.expire();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void expire() {
            LOG.debug("Running expiry");
            Iterator<NFSFile> i = this.dirtyFilesSet.iterator();
            while (i.hasNext()) {
                NFSFile file;
                NFSFile nFSFile = file = i.next();
                synchronized (nFSFile) {
                    if (file.getLastAccessTimestamp() + (long)file.getExport().getCacheTimeout() < System.currentTimeMillis()) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Flushing cache for " + file.getFile());
                            }
                            file.flushCache();
                            this.openFilesSet.remove(file);
                            i.remove();
                        }
                        catch (IOException e) {
                            LOG.warn("Got exception flushing cache for " + file.getFile());
                        }
                    }
                }
            }
            if (this.dirtyFilesSet.size() == 0 && this.openFilesSet.size() != 0) {
                this.openFilesSet.clear();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Expiry done. Dirty files remaining: " + this.dirtyFilesSet.size() + " open files remaining: " + this.openFilesSet.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void watermarkCacheFlush() {
            LOG.info("Number of open files: " + this.openFilesSet.size() + ". Forcing flush of cache.");
            ArrayList<NFSFile> sortedList = new ArrayList<NFSFile>(this.dirtyFilesSet);
            Collections.sort(sortedList, new Comparator<NFSFile>(){

                @Override
                public int compare(NFSFile f1, NFSFile f2) {
                    return (int)(f1.getLastAccessTimestamp() - f2.getLastAccessTimestamp());
                }
            });
            int lowWaterMark = 170;
            Iterator i = sortedList.iterator();
            while (i.hasNext()) {
                NFSFile file;
                NFSFile nFSFile = file = (NFSFile)i.next();
                synchronized (nFSFile) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Flushing cache for file of age " + (System.currentTimeMillis() - file.getLastAccessTimestamp()));
                        }
                        file.flushCache();
                        this.openFilesSet.remove(file);
                        this.dirtyFilesSet.remove(file);
                    }
                    catch (IOException e) {
                        LOG.warn("Got exception flushing cache for " + file.getFile());
                    }
                }
                if (this.openFilesSet.size() >= 170) continue;
                break;
            }
        }
    }
}

