/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusProxy;
import org.vaadin.spring.events.internal.ScopedEventBus;
import org.vaadin.spring.events.support.VaadinEventBusAwareProcessor;

@Configuration
public class EventBusConfiguration {
    @Bean
    VaadinEventBusAwareProcessor vaadinEventBusProcessor() {
        return new VaadinEventBusAwareProcessor();
    }

    @Bean
    EventBus.ApplicationEventBus applicationEventBus() {
        return new ScopedEventBus.DefaultApplicationEventBus();
    }

    @Bean
    @Scope(value="vaadin-session", proxyMode=ScopedProxyMode.INTERFACES)
    @EventBusProxy
    EventBus.SessionEventBus proxiedSessionEventBus() {
        return this.sessionEventBus();
    }

    @Bean
    @Scope(value="vaadin-session", proxyMode=ScopedProxyMode.NO)
    @Primary
    EventBus.SessionEventBus sessionEventBus() {
        return new ScopedEventBus.DefaultSessionEventBus(this.applicationEventBus());
    }

    @Bean
    @Scope(value="vaadin-ui", proxyMode=ScopedProxyMode.INTERFACES)
    @EventBusProxy
    EventBus.UIEventBus proxiedUiEventBus() {
        return this.uiEventBus();
    }

    @Bean
    @Scope(value="vaadin-ui", proxyMode=ScopedProxyMode.NO)
    @Primary
    EventBus.UIEventBus uiEventBus() {
        return new ScopedEventBus.DefaultUIEventBus(this.sessionEventBus());
    }

    @Bean
    @Scope(value="vaadin-view", proxyMode=ScopedProxyMode.INTERFACES)
    @EventBusProxy
    EventBus.ViewEventBus proxiedViewEventBus() {
        return this.viewEventBus();
    }

    @Bean
    @Scope(value="vaadin-view", proxyMode=ScopedProxyMode.NO)
    @Primary
    EventBus.ViewEventBus viewEventBus() {
        return new ScopedEventBus.DefualtViewEventBus(this.uiEventBus());
    }
}

