/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.ArchType;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.AddressOption;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.ServerIdentifier;
import org.apache.directory.server.dhcp.options.dhcp.VendorClassIdentifier;
import org.apache.directory.server.dhcp.options.vendor.RootPath;
import org.apache.directory.server.dhcp.service.AbstractDhcpService;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.common.model.util.ConfigProperty;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.DhcpServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPXEService
extends AbstractDhcpService {
    public static final int PXE_DHCP_PORT = 4011;
    protected static final Map<RequestID, Conversation> conversations = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = LoggerFactory.getLogger(AbstractPXEService.class);
    private final RealmService realmService;
    private final ClientService clientService;
    private final UnrecognizedClientService unrecognizedClientService;
    private final Set<Realm> realms;
    private String defaultNextServerAddress;
    private volatile boolean trackUnrecognizedPXEClients;
    private DhcpServiceConfiguration.PXEPolicy policy;

    public AbstractPXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        this.realmService = realmService;
        this.clientService = clientService;
        this.unrecognizedClientService = unrecognizedClientService;
        try {
            this.realms = this.realmService.findAllRealms();
            for (Realm realm : this.realms) {
                logger.info("Serving realm " + realm);
            }
        }
        catch (Exception e) {
            logger.error("Can't init directory", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void expireConversations() {
        Map<RequestID, Conversation> map = conversations;
        synchronized (map) {
            Iterator<Conversation> i = conversations.values().iterator();
            while (i.hasNext()) {
                Conversation c = i.next();
                if (!c.isExpired()) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("Expiring expired conversation " + c);
                }
                i.remove();
            }
        }
    }

    protected static boolean isZeroAddress(InetAddress a) {
        byte[] addr = a.getAddress();
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected static boolean isInSubnet(byte[] ip, byte[] network, short prefix) {
        int i;
        if (ip.length != network.length) {
            return false;
        }
        if (prefix / 8 > ip.length) {
            return false;
        }
        for (i = 0; prefix >= 8 && i < ip.length; ++i, prefix = (short)(prefix - 8)) {
            if (ip[i] == network[i]) continue;
            return false;
        }
        byte mask = (byte)(~((1 << 8 - prefix) - 1));
        return (ip[i] & mask) == (network[i] & mask);
    }

    public boolean isTrackUnrecognizedPXEClients() {
        return this.trackUnrecognizedPXEClients;
    }

    public void setTrackUnrecognizedPXEClients(boolean trackUnrecognizedPXEClients) {
        this.trackUnrecognizedPXEClients = trackUnrecognizedPXEClients;
    }

    protected boolean assertCorrectPort(InetSocketAddress localAddress, int port, DhcpMessage m) {
        if (localAddress.getPort() != port) {
            logger.debug("Ignoring " + m.getMessageType() + " on wrong port " + localAddress.getPort());
            return false;
        }
        return true;
    }

    private String getBootfileName(DhcpMessage message, Client client) {
        switch (ArchType.fromMessage((DhcpMessage)message)) {
            case UEFI32: {
                return "syslinux32.efi";
            }
            case UEFI64: {
                return "syslinux64.efi";
            }
        }
        return (String)Config.BootOptions.BootfileName.get((Profile)client);
    }

    protected void trackUnrecognizedClient(DhcpMessage discover, String ipHostNumber) {
        if (!this.isTrackUnrecognizedPXEClients()) {
            return;
        }
        String hwAddressString = discover.getHardwareAddress().getNativeRepresentation().toLowerCase();
        try {
            VendorClassIdentifier vci = (VendorClassIdentifier)discover.getOptions().get(VendorClassIdentifier.class);
            String description = String.format("last seen: %s (%s)", Instant.now(), vci != null ? vci.getString() : "");
            this.unrecognizedClientService.findByHwAddress(hwAddressString).forEach(uc -> {
                try {
                    uc.getRealm().getDirectory().delete(uc);
                }
                catch (DirectoryException e) {
                    logger.error("Cannot delete unrecognizedClient: " + uc, (Throwable)e);
                    return;
                }
            });
            UnrecognizedClient uc2 = new UnrecognizedClient();
            uc2.setName(hwAddressString);
            uc2.setMacAddress(hwAddressString);
            uc2.setIpHostNumber(ipHostNumber);
            uc2.setDescription(description);
            this.unrecognizedClientService.add(uc2);
        }
        catch (RuntimeException e) {
            logger.error("Can't track unrecognized client", (Throwable)e);
        }
    }

    protected String getLogDetail(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) {
        VendorClassIdentifier vci = (VendorClassIdentifier)request.getOptions().get(VendorClassIdentifier.class);
        return " on " + (null != localAddress ? localAddress : "<null>") + " from " + (null != clientAddress ? clientAddress : "<null>") + " MAC=" + (null != request.getHardwareAddress() ? request.getHardwareAddress() : "<null>") + " ID=" + (null != vci ? vci.getString() : "<???>");
    }

    protected Client getClient(String hwAddressString, InetSocketAddress clientAddress, DhcpMessage request) {
        try {
            Set found = this.clientService.findByHwAddress(hwAddressString);
            if (found.size() > 0) {
                if (found.size() > 1) {
                    logger.warn("Found more than one client for hardware address " + request.getHardwareAddress());
                }
                return (Client)found.iterator().next();
            }
            if (found.size() == 0 && this.policy == DhcpServiceConfiguration.PXEPolicy.ANY_CLIENT) {
                return this.clientService.getDefaultClient();
            }
            return null;
        }
        catch (RuntimeException e) {
            logger.error("Can't query for client for PXE service", (Throwable)e);
            return null;
        }
    }

    protected InetAddress getNextServerAddress(ConfigProperty<String> configProperty, InetSocketAddress localAddress, Client client) {
        InetAddress nsa = null;
        String value = (String)configProperty.get((Profile)client);
        if (value != null && !value.contains("${myip}")) {
            nsa = this.safeGetInetAddress(value);
        }
        if (null == nsa && null != this.defaultNextServerAddress) {
            nsa = this.safeGetInetAddress(this.defaultNextServerAddress);
        }
        if (null == nsa) {
            nsa = localAddress.getAddress();
        }
        return nsa;
    }

    private InetAddress safeGetInetAddress(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (IOException e) {
            logger.warn("Invalid inet address: " + name);
            return null;
        }
    }

    protected InetSocketAddress determineServerAddress(InetSocketAddress localAddress, DhcpMessage message) {
        return localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage handleREQUEST(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        InetSocketAddress serverAddress;
        Client client;
        if (!ArchType.isPXEClient((DhcpMessage)request)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring non-PXE REQUEST" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Got PXE REQUEST" + this.getLogDetail(localAddress, clientAddress, request));
        }
        if (AbstractPXEService.isZeroAddress(clientAddress.getAddress())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring PXE REQUEST from 0.0.0.0" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        if (!this.assertCorrectPort(localAddress, 4011, request)) {
            return null;
        }
        RequestID id = new RequestID(request);
        Conversation conversation = conversations.get(id);
        if (null == conversation) {
            if (ArchType.isUEFI((DhcpMessage)request)) {
                String hwAddressString = request.getHardwareAddress().getNativeRepresentation();
                client = this.getClient(hwAddressString, clientAddress, request);
                if (client == null) {
                    return null;
                }
                logger.info("Got UEFI PXE REQUEST for which there is no conversation. Serving anyway." + this.getLogDetail(localAddress, clientAddress, request));
                Conversation conversation2 = conversation = new Conversation(request);
                synchronized (conversation2) {
                    conversation.setClient(client);
                    serverAddress = this.determineServerAddress(localAddress, request);
                    conversation.setApplicableServerAddress(serverAddress);
                }
            } else {
                logger.info("Got BIOS PXE REQUEST for which there is no conversation" + this.getLogDetail(localAddress, clientAddress, request));
                return null;
            }
        }
        Conversation conversation3 = conversation;
        synchronized (conversation3) {
            AddressOption serverIdentOption;
            if (conversation.isExpired()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got PXE REQUEST for an expired conversation: " + conversation);
                }
                conversations.remove(id);
                return null;
            }
            client = conversation.getClient();
            if (null == client) {
                logger.warn("Got PXE request which we didn't send an offer. Someone else is serving PXE around here?");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Got PXE REQUEST within " + conversation);
            }
            if (null != (serverIdentOption = (AddressOption)request.getOptions().get(ServerIdentifier.class)) && serverIdentOption.getAddress().isAnyLocalAddress()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring PXE REQUEST for server " + serverIdentOption);
                }
                return null;
            }
            serverAddress = conversation.getApplicableServerAddress();
            DhcpMessage reply = this.initGeneralReply(serverAddress, request);
            reply.setMessageType(MessageType.DHCPACK);
            OptionsField options = reply.getOptions();
            VendorClassIdentifier vci = new VendorClassIdentifier();
            vci.setString("PXEClient");
            options.add((DhcpOption)vci);
            reply.setNextServerAddress(this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.TFTPBootserver, serverAddress, client));
            String rootPath = this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.NFSRootserver, serverAddress, client).getHostAddress() + ":" + (String)Config.BootOptions.NFSRootPath.get((Profile)client);
            options.add((DhcpOption)new RootPath(rootPath));
            reply.setBootFileName(this.getBootfileName(request, client));
            if (logger.isInfoEnabled()) {
                logger.info("Sending PXE proxy ACK rootPath=" + rootPath + " bootFileName=" + reply.getBootFileName() + " nextServerAddress=" + reply.getNextServerAddress().getHostAddress() + " reply=" + reply);
            }
            return reply;
        }
    }

    public abstract void init(IoAcceptor var1, IoHandler var2, IoServiceConfig var3) throws IOException;

    public DhcpServiceConfiguration.PXEPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(DhcpServiceConfiguration.PXEPolicy policy) {
        this.policy = policy;
    }

    public final class Conversation {
        private static final int CONVERSATION_EXPIRY = 60000;
        private final DhcpMessage discover;
        private Client client;
        private DhcpMessage offer;
        private long lastAccess;
        private InetSocketAddress applicableServerAddress;

        public Conversation(DhcpMessage discover) {
            this.discover = discover;
            this.touch();
        }

        private void touch() {
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return this.lastAccess < System.currentTimeMillis() - 60000L;
        }

        public DhcpMessage getOffer() {
            this.touch();
            return this.offer;
        }

        public void setOffer(DhcpMessage offer) {
            this.touch();
            this.offer = offer;
        }

        public DhcpMessage getDiscover() {
            this.touch();
            return this.discover;
        }

        public Client getClient() {
            this.touch();
            return this.client;
        }

        public void setClient(Client client) {
            this.client = client;
        }

        public String toString() {
            return "Conversation[" + this.discover.getHardwareAddress() + "/" + this.discover.getTransactionId() + "]: age=" + (System.currentTimeMillis() - this.lastAccess) + ", client=" + this.client;
        }

        public InetSocketAddress getApplicableServerAddress() {
            return this.applicableServerAddress;
        }

        public void setApplicableServerAddress(InetSocketAddress applicableServerAddress) {
            this.applicableServerAddress = applicableServerAddress;
        }
    }

    public static final class RequestID {
        private final HardwareAddress mac;
        private final int transactionID;

        public RequestID(DhcpMessage m) {
            this.mac = m.getHardwareAddress();
            this.transactionID = m.getTransactionId();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(this.getClass()) && this.transactionID == ((RequestID)obj).transactionID && this.mac.equals((Object)((RequestID)obj).mac);
        }

        public int hashCode() {
            return 0xCBBE4 ^ this.transactionID ^ this.mac.hashCode();
        }
    }
}

