/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.net.InetSocketAddress;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.ArchType;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.VendorClassIdentifier;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.common.model.util.ConfigProperty;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.AbstractPXEService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePXEService
extends AbstractPXEService {
    protected static final Logger logger = LoggerFactory.getLogger(BasePXEService.class);

    public BasePXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage handleDISCOVER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        AbstractPXEService.Conversation conversation;
        BasePXEService.expireConversations();
        if (!this.assertCorrectPort(localAddress, 67, request)) {
            return null;
        }
        if (!ArchType.isPXEClient((DhcpMessage)request)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring non-PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        AbstractPXEService.RequestID requestID = new AbstractPXEService.RequestID(request);
        if (logger.isInfoEnabled()) {
            logger.info("Got PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
        }
        AbstractPXEService.Conversation conversation2 = conversation = new AbstractPXEService.Conversation(request);
        synchronized (conversation2) {
            conversations.put(requestID, conversation);
            String hwAddressString = request.getHardwareAddress().getNativeRepresentation();
            Client client = this.getClient(hwAddressString, clientAddress, request);
            if (null == client) {
                logger.info("Client not eligible for PXE proxy service");
                this.trackUnrecognizedClient(request, null);
                return null;
            }
            if ("00:00:00:00:00:00".equals(client.getIpHostNumber())) {
                this.trackUnrecognizedClient(request, null);
            }
            conversation.setClient(client);
            logger.info("Conversation started");
            return this.myHandleOFFER(localAddress, clientAddress, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage myHandleOFFER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage offer) throws DhcpException {
        AbstractPXEService.RequestID id = new AbstractPXEService.RequestID(offer);
        AbstractPXEService.Conversation conversation = (AbstractPXEService.Conversation)conversations.get(id);
        if (null == conversation) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got OFFER for which there is no conversation" + this.getLogDetail(localAddress, clientAddress, offer));
            }
            return null;
        }
        AbstractPXEService.Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (conversation.isExpired()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got OFFER for an expired conversation: " + conversation);
                }
                conversations.remove(id);
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Got OFFER within " + conversation);
            }
            InetSocketAddress serverAddress = this.determineServerAddress(localAddress, offer);
            conversation.setApplicableServerAddress(serverAddress);
            DhcpMessage reply = this.initGeneralReply(serverAddress, offer);
            reply.setMessageType(MessageType.DHCPOFFER);
            OptionsField options = reply.getOptions();
            VendorClassIdentifier vci = new VendorClassIdentifier();
            vci.setString("PXEClient");
            options.add((DhcpOption)vci);
            Client client = conversation.getClient();
            if (null != client) {
                reply.setNextServerAddress(this.getNextServerAddress((ConfigProperty<String>)Config.BootOptions.TFTPBootserver, conversation.getApplicableServerAddress(), client));
            }
            if (logger.isInfoEnabled()) {
                logger.info("Sending PXE proxy offer " + offer);
            }
            return reply;
        }
    }
}

