/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.service.common.ServerIDFactory;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.ManagerHomeMetadata;
import org.openthinclient.web.pkgmngr.event.PackageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"serviceManager", "liquibase"})
public class Migrations {
    private static Logger LOG = LoggerFactory.getLogger(Migrations.class);
    private static Version version2020 = Version.parse((String)"2020");
    @Autowired
    private PackageManager pkgManager;
    @Autowired
    private LocationService locationService;
    private static String[] obsoletePackageNames = new String[]{"openthinclient-manager", "openthinclient-server-tftp", "openthinclient-server-ldap", "openthinclient-server-dhcp", "openthinclient-server-nfs", "tcos-scripts"};
    private static String[] obsoleteWithTcosLibs2020PackageNames = new String[]{"tcos-devices", "desktop"};
    private static String[] extensions = new String[]{"sfs", "md5", "changelog"};

    @Autowired
    public void setServerId(ManagerHome managerHome) {
        ManagerHomeMetadata meta = managerHome.getMetadata();
        if (Strings.isNullOrEmpty((String)meta.getServerID())) {
            meta.setServerID(ServerIDFactory.create());
            meta.save();
        }
        LOG.info("Server ID: {}", (Object)meta.getServerID());
    }

    @PostConstruct
    public void init() {
        if (this.tcosLibs2020IsInstalled()) {
            this.updateLocationTimezone();
            this.removeObsoleteackageFiles(obsoleteWithTcosLibs2020PackageNames);
        }
        this.removeObsoleteackageFiles(obsoletePackageNames);
    }

    @EventListener
    public void onPackageEvent(PackageEvent ev) {
        if (this.tcosLibs2020Updated(ev.getReports())) {
            this.updateLocationTimezone();
            this.removeObsoleteackageFiles(obsoleteWithTcosLibs2020PackageNames);
        }
    }

    private void removeObsoleteackageFiles(String[] packageNames) {
        Path root = this.pkgManager.getConfiguration().getInstallDir().toPath();
        Path pkgPath = root.resolve("sfs/package");
        for (String pkgName : packageNames) {
            for (String ext : extensions) {
                try {
                    Path path = pkgPath.resolve(pkgName + "." + ext);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    LOG.info("Deleting obsolete {}", (Object)path);
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateLocationTimezone() {
        for (Location location : this.locationService.findAll()) {
            String tz = location.getValueLocal("Time.localtime");
            if (tz == null || !tz.startsWith("posix/")) continue;
            LOG.info("Updating timezone for {}", (Object)location.getName());
            location.setValue("Time.localtime", tz.substring(6));
            this.locationService.save((DirectoryObject)location);
        }
    }

    private boolean tcosLibs2020IsInstalled() {
        return this.pkgManager.getInstalledPackages().stream().anyMatch(arg_0 -> this.isTcosLibs2020(arg_0));
    }

    private boolean isTcosLibs2020(Package pkg) {
        return "tcos-libs".equals(pkg.getName()) && pkg.getVersion().compareTo((Object)version2020) != -1;
    }

    private boolean tcosLibs2020Updated(List<PackageManagerOperationReport.PackageReport> reports) {
        LOG.info("tcosLibs2020Updated?", reports);
        return reports.stream().anyMatch(report -> this.isTcosLibs2020(report.getPackage()) && (report.getType().equals((Object)PackageManagerOperationReport.PackageReportType.UPGRADE) || report.getType().equals((Object)PackageManagerOperationReport.PackageReportType.INSTALL)));
    }
}

