/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.servlet;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FileServiceServlet.class);
    private final File basedir;

    public FileServiceServlet(File basedir) {
        this.basedir = basedir;
    }

    public String[] listFiles(String dirName) throws IOException {
        File dir = this.makeFile(dirName);
        if (logger.isDebugEnabled()) {
            logger.debug("Listing files in " + dir);
        }
        return dir.list();
    }

    public ByteArrayInputStream getFile(String fileName) throws IOException {
        int read;
        File file = this.makeFile(fileName);
        if (logger.isDebugEnabled()) {
            logger.debug("Getting file " + file);
        }
        FileInputStream is = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = is.read(buffer)) > 0) {
            baos.write(buffer, 0, read);
        }
        is.close();
        return null;
    }

    private File makeFile(String name) throws IOException {
        File f = Strings.isNullOrEmpty((String)name) ? this.basedir : new File(this.basedir, name);
        String canonicalPath = f.getCanonicalPath();
        if (!canonicalPath.startsWith(this.basedir.getCanonicalPath())) {
            throw new IOException("The file named " + name + " can or may not be resolved.");
        }
        return f;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File f = this.makeFile(request.getPathInfo());
        if (!f.exists() || !f.canRead()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Won't serve this file: " + f);
            }
            response.sendError(404);
        } else if (f.isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Listing Directory: " + f);
            }
            response.setContentType("text/plain");
            response.setCharacterEncoding("ISO-8859-1");
            PrintWriter w = response.getWriter();
            for (File file : f.listFiles()) {
                w.write(file.isDirectory() ? "D " : "F ");
                w.write(file.getName());
                w.write("\n");
            }
        } else {
            int read;
            if (logger.isDebugEnabled()) {
                logger.debug("Getting file: " + f);
            }
            response.setContentType("application/octet-stream");
            ServletOutputStream os = response.getOutputStream();
            FileInputStream is = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                os.write(buffer, 0, read);
            }
            is.close();
            os.flush();
        }
    }
}

