/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.util.Assert;

public class JobParametersBuilder {
    private Map<String, JobParameter> parameterMap;
    private JobExplorer jobExplorer;

    public JobParametersBuilder() {
        this.parameterMap = new LinkedHashMap<String, JobParameter>();
    }

    public JobParametersBuilder(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
        this.parameterMap = new LinkedHashMap<String, JobParameter>();
    }

    public JobParametersBuilder(JobParameters jobParameters) {
        this(jobParameters, null);
    }

    public JobParametersBuilder(Properties properties) {
        this.parameterMap = new LinkedHashMap<String, JobParameter>();
        if (properties != null) {
            for (Map.Entry<Object, Object> curProperty : properties.entrySet()) {
                this.parameterMap.put((String)curProperty.getKey(), new JobParameter((String)curProperty.getValue(), false));
            }
        }
    }

    public JobParametersBuilder(JobParameters jobParameters, JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
        this.parameterMap = new LinkedHashMap<String, JobParameter>(jobParameters.getParameters());
    }

    public JobParametersBuilder addString(String key, String parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addString(String key, String parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addDate(String key, Date parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addDate(String key, Date parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addLong(String key, Long parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addLong(String key, Long parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addDouble(String key, Double parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addDouble(String key, Double parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParameters toJobParameters() {
        return new JobParameters(this.parameterMap);
    }

    public JobParametersBuilder addParameter(String key, JobParameter jobParameter) {
        Assert.notNull((Object)jobParameter, (String)"JobParameter must not be null");
        this.parameterMap.put(key, jobParameter);
        return this;
    }

    public JobParametersBuilder addJobParameters(JobParameters jobParameters) {
        Assert.notNull((Object)jobParameters, (String)"jobParameters must not be null");
        this.parameterMap.putAll(jobParameters.getParameters());
        return this;
    }

    public JobParametersBuilder getNextJobParameters(Job job) {
        JobParameters nextParameters;
        Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer is required to get next job parameters");
        Assert.notNull((Object)job, (String)"Job must not be null");
        Assert.notNull((Object)job.getJobParametersIncrementer(), (String)("No job parameters incrementer found for job=" + job.getName()));
        String name = job.getName();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(name, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (lastInstances.isEmpty()) {
            nextParameters = incrementer.getNext(new JobParameters());
        } else {
            List<JobExecution> previousExecutions = this.jobExplorer.getJobExecutions(lastInstances.get(0));
            if (previousExecutions.isEmpty()) {
                nextParameters = incrementer.getNext(new JobParameters());
            } else {
                JobExecution previousExecution = previousExecutions.get(0);
                nextParameters = incrementer.getNext(previousExecution.getJobParameters());
            }
        }
        HashMap<String, JobParameter> nextParametersMap = new HashMap<String, JobParameter>(nextParameters.getParameters());
        nextParametersMap.putAll(this.parameterMap);
        this.parameterMap = nextParametersMap;
        return this;
    }
}

