/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.i18n;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.vaadin.spring.i18n.CompositeMessageSource;

public class MessageProviderCacheCleanupExecutor {
    public static final String ENV_PROP_MESSAGE_PROVIDER_CACHE_CLEANUP_INTERVAL_SECONDS = "vaadin4spring.i18n.message-provider-cache.cleanup-interval-seconds";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProviderCacheCleanupExecutor.class);
    private ScheduledExecutorService executorService;
    private int cleanupInterval;
    private ScheduledFuture<?> cleanupJob;

    public MessageProviderCacheCleanupExecutor(Environment environment, final CompositeMessageSource compositeMessageSource) {
        this.cleanupInterval = (Integer)environment.getProperty(ENV_PROP_MESSAGE_PROVIDER_CACHE_CLEANUP_INTERVAL_SECONDS, Integer.class, (Object)0);
        if (this.cleanupInterval > 0) {
            if (compositeMessageSource.isMessageFormatCacheEnabled()) {
                LOGGER.warn("The message format cache is enabled so message provider cache cleanup will not have any effect, disabling");
            } else {
                LOGGER.info("Cleaning up the message provider caches every {} second(s)", (Object)this.cleanupInterval);
                this.executorService = Executors.newSingleThreadScheduledExecutor();
                this.cleanupJob = this.executorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.debug("Cleaning up message provider caches");
                        compositeMessageSource.clearMessageProviderCaches();
                    }
                }, this.cleanupInterval, this.cleanupInterval, TimeUnit.SECONDS);
            }
        } else {
            LOGGER.info("Message provider cache cleanup is disabled");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.executorService != null) {
            LOGGER.info("Shutting down message provider cache cleanup thread");
            this.cleanupJob.cancel(true);
            this.executorService.shutdown();
        }
    }
}

