/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openthinclient.advisor.cDHCPClient;
import org.openthinclient.advisor.cKillServer;
import org.openthinclient.advisor.cPortScanner;
import org.openthinclient.advisor.cReadWriteSplit;
import org.openthinclient.advisor.cServer;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.openthinclient.advisor.check.CheckInternetConnection;
import org.openthinclient.advisor.check.CheckNetworkInferfaces;
import org.openthinclient.advisor.inventory.SystemInventory;
import org.openthinclient.advisor.inventory.SystemInventoryFactory;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public class cNetwork {
    private static SystemInventory systemInventory;
    private static boolean internet;
    private static boolean nics;
    private static boolean serverrun;
    private NetworkConfiguration.ProxyConfiguration proxyConfiguration = this.getSystemProxy();
    private String hostname = "";

    public cNetwork() {
        if (this.proxyConfiguration == null) {
            this.proxyConfiguration = new NetworkConfiguration.ProxyConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemInventory getSystemInventory() {
        if (systemInventory != null) return systemInventory;
        Class<cNetwork> clazz = cNetwork.class;
        synchronized (cNetwork.class) {
            if (systemInventory != null) return systemInventory;
            SystemInventoryFactory factory = new SystemInventoryFactory((AsyncListenableTaskExecutor)new SimpleAsyncTaskExecutor());
            try {
                systemInventory = (SystemInventory)factory.determineSystemInventory().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to determine the SystemInventory", e);
            }
            return systemInventory;
        }
    }

    public static void PortScanner(String ServerIP) {
        String host = ServerIP;
        try {
            String[] splittArray = cReadWriteSplit.readSplitFile("ports.ini", "\\;");
            for (int i = 0; i < splittArray.length; ++i) {
                int port = Integer.parseInt(splittArray[i]);
                cPortScanner curr = new cPortScanner(host, port);
                Thread th = new Thread(curr);
                th.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getLocalIps() {
        String LocalIP = "";
        try {
            Enumeration<NetworkInterface> interfaceNIC = NetworkInterface.getNetworkInterfaces();
            while (interfaceNIC.hasMoreElements()) {
                NetworkInterface n = interfaceNIC.nextElement();
                Enumeration<InetAddress> addresses = n.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.getClass().equals(Inet4Address.class) || n.getName().contains("lo")) continue;
                    LocalIP = LocalIP + String.format("Network-Interface: %s (%s)\r\n", n.getName(), n.getDisplayName());
                    LocalIP = LocalIP + String.format("IP: %s\r\n\r\n", address.getHostAddress());
                }
            }
        }
        catch (SocketException ex) {
            Logger.getLogger(cNetwork.class.getName()).log(Level.SEVERE, null, ex);
        }
        return LocalIP;
    }

    public static boolean internet() {
        return internet;
    }

    public static boolean nics() {
        return nics;
    }

    public static String Networkadapter() throws SocketException {
        CheckExecutionResult result;
        SystemInventory systemInventory = cNetwork.getSystemInventory();
        CheckNetworkInferfaces check = new CheckNetworkInferfaces(Locale.ENGLISH, systemInventory);
        try {
            result = check.call();
        }
        catch (Exception e) {
            result = new CheckExecutionResult(CheckExecutionResult.CheckResultType.FAILED);
        }
        nics = result.getType() == CheckExecutionResult.CheckResultType.SUCCESS || result.getType() == CheckExecutionResult.CheckResultType.WARNING;
        CheckNetworkInferfaces.NetworkInterfacesCheckSummary summary = (CheckNetworkInferfaces.NetworkInterfacesCheckSummary)result.getValue();
        if (summary != null) {
            return summary.getDeviceSummary() + "\r\n" + summary.getMessage();
        }
        return "";
    }

    public static boolean getServerrun() {
        return serverrun;
    }

    private NetworkConfiguration.ProxyConfiguration getSystemProxy() {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> proxies = ProxySelector.getDefault().select(URI.create("http://www.openthinclient.org/"));
            Optional<NetworkConfiguration.ProxyConfiguration> first = proxies.stream().map(Proxy::address).filter(address -> address != null && address instanceof InetSocketAddress).map(address -> (InetSocketAddress)address).map(addr -> {
                NetworkConfiguration.ProxyConfiguration config = new NetworkConfiguration.ProxyConfiguration();
                config.setEnabled(true);
                config.setHost(addr.getHostName());
                config.setPort(addr.getPort());
                return config;
            }).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String verifyInternetConnection() {
        internet = false;
        CheckInternetConnection checker = new CheckInternetConnection(Locale.ENGLISH);
        checker.setProxyConfiguration(this.proxyConfiguration);
        try {
            internet = ((CheckExecutionResult)checker.call()).getType() == CheckExecutionResult.CheckResultType.SUCCESS;
        }
        catch (Exception e) {
            internet = false;
        }
        String Ergebnis = " www.openthinclient.org is not reachable \r\n Internet connectivity not present \r\n Please check your network connection and the proxy settings \r\n";
        if (internet) {
            Ergebnis = " www.openthinclient.org is reachable \r\n Internet connectivy present \r\n";
            return Ergebnis;
        }
        return Ergebnis;
    }

    public void KillServer() {
        serverrun = false;
        try {
            String[] splittArray = cReadWriteSplit.readSplitFile("ports.ini", "\\;");
            for (int i = 0; i < splittArray.length; ++i) {
                int port = Integer.parseInt(splittArray[i]);
                cKillServer curr = new cKillServer(port);
                Thread th = new Thread(curr);
                th.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void RunServer() {
        serverrun = true;
        try {
            String[] splittArray;
            for (String aSplittArray : splittArray = cReadWriteSplit.readSplitFile("ports.ini", "\\;")) {
                int port = Integer.parseInt(aSplittArray);
                Thread t1 = new Thread(new cServer(port));
                t1.start();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(cNetwork.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getHostname() {
        try {
            this.hostname = "" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(cNetwork.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.hostname;
    }

    public String dhcpChecker() {
        SystemInventory systemInventory = cNetwork.getSystemInventory();
        String MACAddress = this.selectMAC(systemInventory);
        cDHCPClient.main(MACAddress);
        return cDHCPClient.getErgebnis();
    }

    protected String selectMAC(SystemInventory systemInventory) {
        Optional<String> candidate = systemInventory.getNetworkInterfaces().getNonLoopbackInterfaces().stream().map(systemInventory.getNetworkInterfaces()::getHardwareAddressString).filter(nic -> !this.isVirtualMachineProviderMAC((String)nic)).findFirst();
        if (candidate.isPresent()) {
            return candidate.get();
        }
        return "00-07-E9-37-2D-02";
    }

    private boolean isVirtualMachineProviderMAC(String mac) {
        return mac.startsWith("00:50:56") || mac.startsWith("00:1C:42");
    }

    public NetworkConfiguration.ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void setProxyConfiguration(NetworkConfiguration.ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    static {
        internet = false;
        nics = false;
        serverrun = false;
    }
}

