/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.EventBusAware;

public class VaadinEventBusAwareProcessor
implements ApplicationContextAware,
BeanPostProcessor {
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        AccessControlContext acc = null;
        if (System.getSecurityManager() != null && bean instanceof EventBusAware) {
            acc = this.applicationContext.getBeanFactory().getAccessControlContext();
        }
        if (acc != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    VaadinEventBusAwareProcessor.this.invokeAwareInterfaces(bean);
                    return null;
                }
            }, acc);
        } else {
            this.invokeAwareInterfaces(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void invokeAwareInterfaces(Object bean) {
        if (bean instanceof EventBusAware) {
            if (bean instanceof EventBusAware.ApplicationEventBusAware) {
                ((EventBusAware.ApplicationEventBusAware)bean).setApplicationEventBus((EventBus.ApplicationEventBus)this.applicationContext.getBean(EventBus.ApplicationEventBus.class));
            }
            if (bean instanceof EventBusAware.SessionEventBusAware) {
                ((EventBusAware.SessionEventBusAware)bean).setSessionEventBus((EventBus.SessionEventBus)this.applicationContext.getBean(EventBus.SessionEventBus.class));
            }
            if (bean instanceof EventBusAware.UIEventBusAware) {
                ((EventBusAware.UIEventBusAware)bean).setUIEventBus((EventBus.UIEventBus)this.applicationContext.getBean(EventBus.UIEventBus.class));
            }
            if (bean instanceof EventBusAware.ViewEventBusAware) {
                ((EventBusAware.ViewEventBusAware)bean).setViewEventBus((EventBus.ViewEventBus)this.applicationContext.getBean(EventBus.ViewEventBus.class));
            }
        }
    }
}

