/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config;

import java.io.File;
import javax.security.auth.callback.CallbackHandler;
import org.openthinclient.common.config.LDAPServicesConfiguration;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.schema.provider.ServerLocalSchemaProvider;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.auth.UsernamePasswordHandler;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={LDAPServicesConfiguration.class})
public class DirectoryServicesConfiguration {
    @Autowired
    ManagerHome managerHome;

    @Bean
    public LDAPConnectionDescriptor ldapConnectionDescriptor() {
        LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor();
        lcd.setProviderType(LDAPConnectionDescriptor.ProviderType.SUN);
        lcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
        DirectoryServiceConfiguration configuration = (DirectoryServiceConfiguration)this.managerHome.getConfiguration(DirectoryServiceConfiguration.class);
        lcd.setCallbackHandler((CallbackHandler)new UsernamePasswordHandler(configuration.getContextSecurityPrincipal(), configuration.getContextSecurityCredentials().toCharArray()));
        return lcd;
    }

    @Bean
    public SchemaProvider schemaProvider() {
        File homeDirectory = this.managerHome.getLocation();
        return new ServerLocalSchemaProvider(homeDirectory.toPath().resolve("nfs").resolve("root").resolve("schema"));
    }
}

