/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.patch;

import java.security.SecureRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.CallbackHandler;
import org.openthinclient.common.directory.ACLUtils;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.auth.UsernamePasswordHandler;
import org.openthinclient.service.apacheds.DirectoryService;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchManagerHome {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchManagerHome.class);
    private static final String[] PW_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-".split("");
    private static final SecureRandom RNG = new SecureRandom();
    private ManagerHome managerHome;
    private DirectoryServiceConfiguration configuration;

    public PatchManagerHome(ManagerHome managerHome) {
        this.managerHome = managerHome;
        this.configuration = (DirectoryServiceConfiguration)managerHome.getConfiguration(DirectoryServiceConfiguration.class);
    }

    public void apply() {
        if (this.configuration.isEmbeddedServerEnabled() && !this.configuration.isAccessControlEnabled()) {
            LOGGER.info("Applying LDAP security patch.");
            try {
                DirectoryService service = new DirectoryService();
                service.setConfiguration(this.configuration);
                service.startService();
                String password = Stream.generate(() -> PW_CHARS[RNG.nextInt(PW_CHARS.length)]).limit(32L).collect(Collectors.joining());
                service.changedEmbeddedAdminPassword(this.configuration.getContextSecurityCredentials(), password);
                this.applyACLs();
                this.configuration.setAccessControlEnabled(true);
                this.managerHome.save(DirectoryServiceConfiguration.class);
                LOGGER.info("LDAP security patch succesfully applied.");
            }
            catch (Exception ex) {
                LOGGER.error("LDAP security patch failed", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyACLs() throws NamingException {
        LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor();
        lcd.setProviderType(LDAPConnectionDescriptor.ProviderType.SUN);
        lcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
        lcd.setCallbackHandler((CallbackHandler)new UsernamePasswordHandler(this.configuration.getContextSecurityPrincipal(), this.configuration.getContextSecurityCredentials().toCharArray()));
        lcd.setBaseDN(String.format("ou=%s,%s", this.configuration.getPrimaryOU(), this.configuration.getEmbeddedCustomRootPartitionName()));
        try (LdapContext ctx = lcd.createDirectoryFacade().createDirContext();){
            ACLUtils aclUtils = new ACLUtils(ctx);
            aclUtils.makeACSA("");
            aclUtils.enableSearchForAllUsers("");
            aclUtils.enableAdminUsers("");
        }
    }
}

