/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar;

import com.vaadin.ui.UI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.sidebar.annotation.SideBarSection;

public class SideBarSectionDescriptor
implements Comparable<SideBarSectionDescriptor> {
    private final SideBarSection section;
    private final I18N i18n;
    private final Set<Class<? extends UI>> availableUIClasses;

    public SideBarSectionDescriptor(SideBarSection section, I18N i18n) {
        this.section = section;
        this.i18n = i18n;
        this.availableUIClasses = new HashSet<Class<? extends UI>>(Arrays.asList(section.ui()));
    }

    public String getCaption() {
        if (this.section.captionCode().isEmpty()) {
            return this.section.caption();
        }
        return this.i18n.get(this.section.captionCode(), new Object[0]);
    }

    public int getOrder() {
        return this.section.order();
    }

    public String getId() {
        return this.section.id();
    }

    public boolean isAvailableFor(Class<? extends UI> uiClass) {
        return this.availableUIClasses.isEmpty() || this.availableUIClasses.contains(uiClass);
    }

    @Override
    public int compareTo(SideBarSectionDescriptor o) {
        return this.getOrder() - o.getOrder();
    }
}

