/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar;

import com.vaadin.navigator.View;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.SideBarSection;
import org.vaadin.spring.sidebar.annotation.SideBarSections;

public class SideBarUtils {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ApplicationContext applicationContext;
    private final I18N i18n;
    private final List<SideBarSectionDescriptor> sections = new ArrayList<SideBarSectionDescriptor>();
    private final List<SideBarItemDescriptor> items = new ArrayList<SideBarItemDescriptor>();

    public SideBarUtils(ApplicationContext applicationContext, I18N i18n) {
        this.applicationContext = applicationContext;
        this.i18n = i18n;
        this.scanForSections();
        Collections.sort(this.sections);
        this.scanForItems();
        Collections.sort(this.items);
    }

    private void scanForSections() {
        String[] beanNames;
        this.logger.debug("Scanning for side bar sections");
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(SideBarSection.class)) {
            this.logger.debug("Bean [{}] declares a side bar section", (Object)beanName);
            this.addSectionDescriptors((SideBarSection)this.applicationContext.findAnnotationOnBean(beanName, SideBarSection.class));
        }
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(SideBarSections.class)) {
            this.logger.debug("Bean [{}] declares multiple side bar sections", (Object)beanName);
            this.addSectionDescriptors(((SideBarSections)this.applicationContext.findAnnotationOnBean(beanName, SideBarSections.class)).value());
        }
    }

    private void addSectionDescriptors(SideBarSection ... sections) {
        for (SideBarSection section : sections) {
            this.logger.debug("Adding side bar section [{}]", (Object)section.id());
            this.sections.add(new SideBarSectionDescriptor(section, this.i18n));
        }
    }

    private void scanForItems() {
        String[] beanNames;
        this.logger.debug("Scanning for side bar items");
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(SideBarItem.class)) {
            this.logger.debug("Bean [{}] declares a side bar item", (Object)beanName);
            Class beanType = this.applicationContext.getType(beanName);
            if (Runnable.class.isAssignableFrom(beanType)) {
                this.logger.debug("Adding side bar item for action [{}]", (Object)beanType);
                this.items.add(new SideBarItemDescriptor.ActionItemDescriptor(beanName, this.applicationContext));
                continue;
            }
            if (!View.class.isAssignableFrom(beanType) || !beanType.isAnnotationPresent(SpringView.class)) continue;
            this.logger.debug("Adding side bar item for view [{}]", (Object)beanType);
            this.items.add(new SideBarItemDescriptor.ViewItemDescriptor(beanName, this.applicationContext));
        }
    }

    public Collection<SideBarSectionDescriptor> getSideBarSections(Class<? extends UI> uiClass) {
        ArrayList<SideBarSectionDescriptor> supportedSections = new ArrayList<SideBarSectionDescriptor>();
        for (SideBarSectionDescriptor section : this.sections) {
            if (!section.isAvailableFor(uiClass)) continue;
            supportedSections.add(section);
        }
        return supportedSections;
    }

    public Collection<SideBarItemDescriptor> getSideBarItems(SideBarSectionDescriptor descriptor) {
        ArrayList<SideBarItemDescriptor> supportedItems = new ArrayList<SideBarItemDescriptor>();
        for (SideBarItemDescriptor item : this.items) {
            if (!item.isMemberOfSection(descriptor)) continue;
            supportedItems.add(item);
        }
        return supportedItems;
    }
}

