/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar.components;

import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import java.util.ArrayList;
import java.util.Collection;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.SideBarUtils;

public abstract class AbstractSideBar<CR extends ComponentContainer>
extends CustomComponent {
    private final SideBarUtils sideBarUtils;
    private SectionComponentFactory<CR> sectionComponentFactory;
    private ItemComponentFactory itemComponentFactory;
    private ItemFilter itemFilter;

    protected AbstractSideBar(SideBarUtils sideBarUtils) {
        this.sideBarUtils = sideBarUtils;
    }

    protected abstract CR createCompositionRoot();

    protected CR getCompositionRoot() {
        return (CR)((ComponentContainer)super.getCompositionRoot());
    }

    public void attach() {
        super.attach();
        CR compositionRoot = this.createCompositionRoot();
        this.setCompositionRoot((Component)compositionRoot);
        for (SideBarSectionDescriptor section : this.sideBarUtils.getSideBarSections(this.getUI().getClass())) {
            this.createSection(compositionRoot, section, this.sideBarUtils.getSideBarItems(section));
        }
    }

    protected abstract SectionComponentFactory<CR> createDefaultSectionComponentFactory();

    protected SectionComponentFactory<CR> getSectionComponentFactory() {
        if (this.sectionComponentFactory == null) {
            this.sectionComponentFactory = this.createDefaultSectionComponentFactory();
        }
        this.sectionComponentFactory.setItemComponentFactory(this.getItemComponentFactory());
        return this.sectionComponentFactory;
    }

    protected void setSectionComponentFactory(SectionComponentFactory<CR> sectionComponentFactory) {
        this.sectionComponentFactory = sectionComponentFactory;
    }

    protected abstract ItemComponentFactory createDefaultItemComponentFactory();

    protected ItemComponentFactory getItemComponentFactory() {
        if (this.itemComponentFactory == null) {
            this.itemComponentFactory = this.createDefaultItemComponentFactory();
        }
        return this.itemComponentFactory;
    }

    protected void setItemComponentFactory(ItemComponentFactory itemComponentFactory) {
        this.itemComponentFactory = itemComponentFactory;
    }

    private void createSection(CR compositionRoot, SideBarSectionDescriptor section, Collection<SideBarItemDescriptor> items) {
        if (items.isEmpty()) {
            return;
        }
        if (this.itemFilter == null) {
            this.getSectionComponentFactory().createSection(compositionRoot, section, items);
        } else {
            ArrayList<SideBarItemDescriptor> passedItems = new ArrayList<SideBarItemDescriptor>();
            for (SideBarItemDescriptor candidate : items) {
                if (!this.itemFilter.passesFilter(candidate)) continue;
                passedItems.add(candidate);
            }
            if (!passedItems.isEmpty()) {
                this.getSectionComponentFactory().createSection(compositionRoot, section, passedItems);
            }
        }
    }

    public void setItemFilter(ItemFilter itemFilter) {
        if (this.isAttached()) {
            throw new IllegalStateException("An ItemFilter cannot be set when the SideBar is attached");
        }
        this.itemFilter = itemFilter;
    }

    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public void detach() {
        this.setCompositionRoot(null);
        super.detach();
    }

    public static interface ItemFilter {
        public boolean passesFilter(SideBarItemDescriptor var1);
    }

    public static interface ItemComponentFactory {
        public Component createItemComponent(SideBarItemDescriptor var1);
    }

    public static interface SectionComponentFactory<CR extends ComponentContainer> {
        public void setItemComponentFactory(ItemComponentFactory var1);

        public void createSection(CR var1, SideBarSectionDescriptor var2, Collection<SideBarItemDescriptor> var3);
    }
}

