/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionTypeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcReqBodyEncoder {
    public byte[] encode(KdcRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)this.encodeInitialSequence(request));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeInitialSequence(KdcRequest request) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DERBitString(request.getKdcOptions().getBytes())));
        if (request.getClientPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)PrincipalNameEncoder.encode(request.getClientPrincipal())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERGeneralString.valueOf((String)request.getRealm().toString())));
        if (request.getServerPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)PrincipalNameEncoder.encode(request.getServerPrincipal())));
        }
        if (request.getFrom() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)KerberosTimeEncoder.encode(request.getFrom())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)KerberosTimeEncoder.encode(request.getTill())));
        if (request.getRtime() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)KerberosTimeEncoder.encode(request.getRtime())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)DERInteger.valueOf((int)request.getNonce())));
        sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)EncryptionTypeEncoder.encode(request.getEType())));
        if (request.getAddresses() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(9, (DEREncodable)HostAddressesEncoder.encodeSequence(request.getAddresses())));
        }
        if (request.getEncAuthorizationData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(10, (DEREncodable)EncryptedDataEncoder.encodeSequence(request.getEncAuthorizationData())));
        }
        if (request.getAdditionalTickets() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(11, (DEREncodable)TicketEncoder.encodeSequence(request.getAdditionalTickets())));
        }
        return sequence;
    }
}

