/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.service;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.ParameterRequestList;
import org.apache.directory.server.dhcp.options.dhcp.ServerIdentifier;
import org.apache.directory.server.dhcp.service.DhcpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDhcpService
implements DhcpService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDhcpService.class);

    @Override
    public final DhcpMessage getReplyFor(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (request.getOp() != 1 && request.getOp() != 2) {
            return null;
        }
        if (null == request.getMessageType()) {
            logger.warn("Missing message type option - plain BOOTP not supported.");
            return null;
        }
        switch (request.getMessageType().getCode()) {
            case 1: {
                return this.handleDISCOVER(localAddress, clientAddress, request);
            }
            case 3: {
                return this.handleREQUEST(localAddress, clientAddress, request);
            }
            case 7: {
                return this.handleRELEASE(localAddress, clientAddress, request);
            }
            case 8: {
                return this.handleINFORM(localAddress, clientAddress, request);
            }
            case 2: {
                return this.handleOFFER(localAddress, clientAddress, request);
            }
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        return this.handleUnknownMessage(clientAddress, request);
    }

    protected DhcpMessage handleUnknownMessage(InetSocketAddress clientAddress, DhcpMessage request) {
        if (logger.isWarnEnabled()) {
            logger.warn("Got unknkown DHCP message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected DhcpMessage handleINFORM(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (logger.isDebugEnabled()) {
            logger.debug("Got INFORM message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected DhcpMessage handleRELEASE(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (logger.isDebugEnabled()) {
            logger.debug("Got RELEASE message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected DhcpMessage handleREQUEST(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (logger.isDebugEnabled()) {
            logger.debug("Got REQUEST message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected DhcpMessage handleDISCOVER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (logger.isDebugEnabled()) {
            logger.debug("Got DISCOVER message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected DhcpMessage handleOFFER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        if (logger.isDebugEnabled()) {
            logger.debug("Got OFFER message: " + request + " from:  " + clientAddress);
        }
        return null;
    }

    protected final DhcpMessage initGeneralReply(InetSocketAddress localAddress, DhcpMessage request) {
        DhcpMessage reply = new DhcpMessage();
        reply.setOp((byte)2);
        reply.setHardwareAddress(request.getHardwareAddress());
        reply.setTransactionId(request.getTransactionId());
        reply.setFlags(request.getFlags());
        reply.setRelayAgentAddress(request.getRelayAgentAddress());
        reply.setServerHostname(localAddress.getHostName());
        reply.getOptions().add(new ServerIdentifier(localAddress.getAddress()));
        return reply;
    }

    private boolean isZeroAddress(byte[] addr) {
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected final InetAddress determineSelectionBase(InetSocketAddress clientAddress, DhcpMessage request) {
        if (!this.isZeroAddress(request.getRelayAgentAddress().getAddress())) {
            return request.getRelayAgentAddress();
        }
        return clientAddress.getAddress();
    }

    protected final void stripUnwantedOptions(DhcpMessage request, OptionsField options) {
        ParameterRequestList prl = (ParameterRequestList)request.getOptions().get(ParameterRequestList.class);
        if (null != prl) {
            byte[] list = prl.getData();
            Iterator i = options.iterator();
            while (i.hasNext()) {
                DhcpOption o = (DhcpOption)i.next();
                for (int j = 0; j < list.length; ++j) {
                    if (list[j] != o.getTag()) continue;
                }
                i.remove();
            }
        }
    }
}

