/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.component;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import java.util.EnumMap;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.web.i18n.ConsoleWebMessages;

public class LicenseMessageBar
extends Label {
    private LicenseManager licenseManager;
    private ClientService clientService;
    private MessageConveyor mc;
    private EnumMap<License.State, String> licenseStateMessage;

    public LicenseMessageBar(LicenseManager licenseManager, ClientService clientService) {
        super("", ContentMode.HTML);
        this.licenseManager = licenseManager;
        this.clientService = clientService;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.initLicenseStateMessages();
        this.updateContent();
    }

    private void initLicenseStateMessages() {
        this.licenseStateMessage = new EnumMap(License.State.class);
        this.licenseStateMessage.put(License.State.REQUIRED_TOO_OLD, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_REQUIRED_TOO_OLD, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_REDUCE));
        this.licenseStateMessage.put(License.State.REQUIRED_OLD, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_OLD, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_REDUCE));
        this.licenseStateMessage.put(License.State.REQUIRED_EXPIRED, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_REQUIRED_EXPIRED, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_REDUCE));
        this.licenseStateMessage.put(License.State.SOFT_EXPIRED, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_SOFT_EXPIRED));
        this.licenseStateMessage.put(License.State.TOO_MANY, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_TOO_MANY));
        this.licenseStateMessage.put(License.State.INVALID, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_INVALID));
        this.licenseStateMessage.put(License.State.REQUIRED_MISSING, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_REQUIRED_MISSING));
        this.licenseStateMessage.put(License.State.TOO_OLD, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_TOO_OLD, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_DELETE));
        this.licenseStateMessage.put(License.State.OLD, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_OLD, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_DELETE));
        this.licenseStateMessage.put(License.State.EXPIRED, this.buildMessageHTML(ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_EXPIRED, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_COUNT, ConsoleWebMessages.UI_SUPPORT_LICENSE_STATE_HINT_DELETE));
    }

    private String buildMessageHTML(ConsoleWebMessages ... keys) {
        StringBuilder sb = new StringBuilder();
        for (ConsoleWebMessages key : keys) {
            sb.append("<p>");
            sb.append(this.mc.getMessage((Enum)key, new Object[0]).replace("\n", "</p><p>"));
            sb.append("</p>");
        }
        return sb.toString();
    }

    public void updateContent() {
        License.State licenseState = this.licenseManager.getLicenseState(this.clientService.count());
        if (licenseState == License.State.OK) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.setValue(this.licenseStateMessage.get(licenseState));
            this.removeStyleNames(new String[]{"warning", "error"});
            this.addStyleName("license-messagebar");
            switch (licenseState) {
                case REQUIRED_TOO_OLD: 
                case REQUIRED_EXPIRED: 
                case TOO_MANY: 
                case INVALID: 
                case REQUIRED_MISSING: {
                    this.addStyleName("error");
                    break;
                }
                default: {
                    this.addStyleName("warning");
                }
            }
        }
    }
}

