/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerUtils;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.PackageDetailsView;
import org.openthinclient.web.pkgmngr.ui.view.PackageDetailsWindow;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;
import org.openthinclient.web.progress.ProgressReceiverDialog;
import org.springframework.context.ApplicationContext;

public class PackageListMasterDetailsPresenter {
    protected final View view;
    protected final ListDataProvider<ResolvedPackageItem> dataProvider;
    protected final PackageManager packageManager;
    protected final IMessageConveyor mc;
    protected final boolean applicationIsPreview;

    public PackageListMasterDetailsPresenter(View view, Consumer<Collection<Package>> detailsPresenter, PackageManager packageManager, ClientService clientService, ApplicationContext applicationContext) {
        this.view = view;
        this.dataProvider = new ListDataProvider(new ArrayList());
        this.view.setDataProvider((DataProvider<ResolvedPackageItem, ?>)this.dataProvider);
        this.packageManager = packageManager;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.applicationIsPreview = (Boolean)applicationContext.getEnvironment().getProperty("application.is-preview", Boolean.class);
        view.onPackageSelected(packages -> {
            if (packages == null || packages.size() == 0) {
                view.setDetailsVisible(false);
            } else {
                view.setDetailsVisible(true);
            }
            detailsPresenter.accept((Collection<Package>)packages);
        });
        view.getAllPackagesFilterCheckbox().setValue(Boolean.valueOf(false));
        view.getAllPackagesFilterCheckbox().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.applyFilters());
        view.getPreviewPackagesFilterCheckbox().setValue(Boolean.valueOf(this.applicationIsPreview));
        view.getPreviewPackagesFilterCheckbox().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.applyFilters());
        view.getAllPackagesFilterCheckbox().setVisible(false);
        view.getPreviewPackagesFilterCheckbox().setVisible(false);
        view.getFilterInput().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.applyFilters());
        view.onShowPackageDetails(pkg -> {
            PackageDetailsView packageDetailsView = new PackageDetailsView();
            PackageDetailsPresenter presenter = new PackageDetailsPresenter(new PackageDetailsWindow(packageDetailsView, (Component)packageDetailsView), packageManager, clientService, applicationContext);
            presenter.setPackage((Package)pkg);
        });
        view.getSourceUpdateButton().addClickListener((Button.ClickListener & Serializable)event -> {
            ListenableProgressFuture update = packageManager.updateCacheDB();
            ProgressReceiverDialog dialog = new ProgressReceiverDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_PROGRESS_CAPTION, new Object[0])){

                @Override
                public void close() {
                    super.close();
                    PackageListMasterDetailsPresenter.this.refreshUpdatePanel();
                }
            };
            dialog.watch(update);
            dialog.open(true);
        });
    }

    public void refreshUpdatePanel() {
        this.packageManager.getSourcesList().getSources().stream().min(Comparator.comparing(Source::getLastUpdated, Comparator.nullsLast(Comparator.reverseOrder()))).ifPresent(lastUpdatedSource -> {
            if (lastUpdatedSource.getLastUpdated() != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SHORT_DATE_FORMAT, new Object[0]));
                this.view.setSourceUpdateLabelValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_LASTUPDATE_LABEL, new Object[]{lastUpdatedSource.getLastUpdated().format(formatter)}));
            }
        });
    }

    protected void applyFilters() {
        this.dataProvider.clearFilters();
        String value = this.view.getFilterInput().getValue().trim();
        if (!value.isEmpty()) {
            this.dataProvider.addFilter(AbstractPackageItem::getName, (SerializablePredicate & Serializable)s -> s.toLowerCase().contains(value.toLowerCase()));
        }
        this.dataProvider.addFilter((SerializablePredicate)new HideOTCManagerVersionFilter());
    }

    public void showPackageListLoadingError(Exception e) {
    }

    public void setPackages(Collection<Package> packages) {
        this.dataProvider.getItems().clear();
        this.dataProvider.getItems().addAll(packages.stream().map(ResolvedPackageItem::new).collect(Collectors.toList()));
        this.applyFilters();
        this.dataProvider.refreshAll();
        this.view.clearSelection();
        this.view.sort(View.SortableProperty.NAME, SortDirection.ASCENDING);
    }

    public static class HideOTCManagerVersionFilter
    implements SerializablePredicate<ResolvedPackageItem> {
        public static final String OPENTHINCLIENT_MANAGER_VERSION_NAME = "openthinclient-manager-version";

        public boolean test(ResolvedPackageItem item) {
            return !StringUtils.equalsIgnoreCase((CharSequence)item.getName(), (CharSequence)OPENTHINCLIENT_MANAGER_VERSION_NAME);
        }
    }

    public static class LatestVersionOnlyFilter
    implements SerializablePredicate<ResolvedPackageItem> {
        private final List<Package> latestVersionPackageList;

        public LatestVersionOnlyFilter(ListDataProvider<ResolvedPackageItem> dataProvider) {
            PackageManagerUtils pmu = new PackageManagerUtils();
            this.latestVersionPackageList = pmu.reduceToLatestVersion(dataProvider.getItems().stream().map(item -> item.getPackage()).collect(Collectors.toList()));
        }

        public boolean test(ResolvedPackageItem item) {
            Package pkg = item.getPackage();
            return this.latestVersionPackageList.stream().anyMatch(p -> p.compareTo(pkg) == 0 && p.getSource().equals((Object)pkg.getSource()));
        }
    }

    public static interface View {
        public TextField getFilterInput();

        public void onPackageSelected(Consumer<Collection<Package>> var1);

        public void onShowPackageDetails(Consumer<Package> var1);

        public CheckBox getAllPackagesFilterCheckbox();

        public CheckBox getPreviewPackagesFilterCheckbox();

        public void setDataProvider(DataProvider<ResolvedPackageItem, ?> var1);

        public void sort(SortableProperty var1, SortDirection var2);

        public void setDetailsVisible(boolean var1);

        public void hideSourceUpdatePanel();

        public void setSourceUpdateLabelValue(String var1);

        public Button getSourceUpdateButton();

        public void clearSelection();

        public static enum SortableProperty {
            NAME("name");

            private final String beanPropertyName;

            private SortableProperty(String beanPropertyName) {
                this.beanPropertyName = beanPropertyName;
            }

            public String getBeanPropertyName() {
                return this.beanPropertyName;
            }
        }
    }
}

