/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.progress;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import org.openthinclient.pkgmgr.exception.PackageManagerDownloadException;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.progress.AbstractProgressReceiver;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.progress.UIAccessProgressReceiverProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;
import org.vaadin.viritin.layouts.MVerticalLayout;

public class ProgressReceiverDialog {
    private final Logger LOGGER = LoggerFactory.getLogger(ProgressReceiverDialog.class);
    private final ProgressBar progressBar;
    private final Label messageLabel;
    private final Window window;
    private final HorizontalLayout header;
    private final HorizontalLayout footer;
    private final IMessageConveyor mc;

    public ProgressReceiverDialog(String caption) {
        this.window = new Window(caption);
        this.window.setResizable(false);
        this.window.setClosable(false);
        this.window.setWidth(60.0f, Sizeable.Unit.PERCENTAGE);
        this.window.setHeight(null);
        this.window.center();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        VerticalLayout content = new VerticalLayout();
        content.setMargin(true);
        content.setWidth("100%");
        this.messageLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_CAPTION, new Object[0]));
        this.progressBar = new ProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        content.addComponent((Component)this.messageLabel);
        content.addComponent((Component)this.progressBar);
        this.header = (HorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().withFullWidth()).withStyleName(new String[]{"v-window-bottom-toolbar"});
        MButton headerCloseButton = ((MButton)new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CLOSE, new Object[0])).withStyleName(new String[]{"primary"})).withListener((Button.ClickListener & Serializable)event -> this.close());
        this.header.addComponent((Component)headerCloseButton);
        this.header.setComponentAlignment((Component)headerCloseButton, Alignment.MIDDLE_RIGHT);
        this.footer = (HorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().withFullWidth()).withStyleName(new String[]{"v-window-bottom-toolbar"});
        MButton footerCloseButton = ((MButton)new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CLOSE, new Object[0])).withStyleName(new String[]{"primary"})).withListener((Button.ClickListener & Serializable)event -> this.close());
        this.footer.addComponent((Component)footerCloseButton);
        this.footer.setComponentAlignment((Component)footerCloseButton, Alignment.MIDDLE_RIGHT);
        this.window.setContent((Component)content);
        this.window.center();
    }

    public void open(boolean modal) {
        this.LOGGER.debug("open window");
        this.window.setModal(modal);
        UI ui = UI.getCurrent();
        if (!ui.getWindows().contains(this.window)) {
            ui.setPollInterval(500);
            ui.addWindow(this.window);
        }
    }

    public void close() {
        UI.getCurrent().setPollInterval(-1);
        UI.getCurrent().removeWindow(this.window);
        this.LOGGER.debug("close");
    }

    public void watch(ListenableProgressFuture<?> future) {
        future.addProgressReceiver(this.createProgressReceiver());
        future.addCallback(this::onSuccess, this::onError);
    }

    public ProgressReceiver createProgressReceiver() {
        return new UIAccessProgressReceiverProxy(() -> ((Window)this.window).getUI(), (ProgressReceiver)new AbstractProgressReceiver(){

            public void progress(String message, double progress) {
                ProgressReceiverDialog.this.onProgress(message, progress);
            }

            public void progress(String message) {
                ProgressReceiverDialog.this.onProgress(message);
            }

            public void progress(double progress) {
                ProgressReceiverDialog.this.onProgress(progress);
            }

            public void completed() {
                ProgressReceiverDialog.this.onCompleted();
            }
        });
    }

    private void onSuccess(Object res) {
        UI ui = this.window.getUI();
        ui.access(() -> {
            ui.setPollInterval(-1);
            if (res instanceof PackageManagerOperationReport) {
                this.onSuccess((PackageManagerOperationReport)res);
            } else if (res instanceof PackageListUpdateReport) {
                this.onSuccess((PackageListUpdateReport)res);
            }
        });
    }

    private void onSuccess(PackageListUpdateReport report) {
        Label checkLabel = new Label(VaadinIcons.CHECK_CIRCLE.getHtml() + " " + this.mc.getMessage((Enum)ConsoleWebMessages.UI_CAPTION_SUCCESS, new Object[0]), ContentMode.HTML);
        checkLabel.setStyleName("state-label-success-xl");
        VerticalLayout operationReport = new VerticalLayout();
        operationReport.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_INFO_ADDED, new Object[0]) + " " + report.getAdded()));
        operationReport.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_INFO_REMOVED, new Object[0]) + " " + report.getRemoved()));
        operationReport.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_INFO_UPDATED, new Object[0]) + " " + report.getUpdated()));
        operationReport.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_INFO_SKIPPED, new Object[0]) + " " + report.getSkipped()));
        this.window.setContent((Component)((MVerticalLayout)((MVerticalLayout)new MVerticalLayout(new Component[]{checkLabel, this.header, operationReport, this.footer}).withFullWidth()).withMargin(true)).withSpacing(true));
        this.window.center();
    }

    public void onSuccess(PackageManagerOperationReport report) {
        Label checkLabel = new Label(VaadinIcons.CHECK_CIRCLE.getHtml() + " " + this.mc.getMessage((Enum)ConsoleWebMessages.UI_CAPTION_SUCCESS, new Object[0]), ContentMode.HTML);
        checkLabel.setStyleName("state-label-success-xl");
        Grid operationReport = new Grid();
        if (report != null) {
            operationReport.setDataProvider((DataProvider)DataProvider.ofCollection((Collection)report.getPackageReports()));
            operationReport.setWidth("100%");
            operationReport.setHeightByRows((double)report.getPackageReports().size());
            operationReport.addColumn(PackageManagerOperationReport.PackageReport::getPackageName);
            operationReport.addColumn(PackageManagerOperationReport.PackageReport::getType);
            operationReport.setHeaderVisible(false);
        }
        this.window.setContent((Component)((MVerticalLayout)((MVerticalLayout)new MVerticalLayout(new Component[]{checkLabel, this.header, operationReport, this.footer}).withFullWidth()).withMargin(true)).withSpacing(true));
        this.window.center();
    }

    public void onError(Throwable throwable) {
        UI ui = this.window.getUI();
        ui.access(() -> {
            ui.setPollInterval(-1);
            Label errorLabel = new Label(VaadinIcons.SPINNER.getHtml() + " " + this.mc.getMessage((Enum)ConsoleWebMessages.UI_CAPTION_FAILED, new Object[0]), ContentMode.HTML);
            errorLabel.setStyleName("state-label-error-xl");
            Label errorMessage = throwable instanceof PackageManagerDownloadException ? new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_AT_SOURCE_ERROR, new Object[]{((PackageManagerDownloadException)throwable).getDownloadUrl()})) : new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_ERROR, new Object[0]));
            this.window.setContent((Component)((MVerticalLayout)((MVerticalLayout)new MVerticalLayout(new Component[]{errorLabel, this.header, errorMessage, this.footer}).withFullWidth()).withMargin(true)).withSpacing(true));
            this.window.center();
        });
    }

    protected void onCompleted() {
        this.LOGGER.debug("completed");
    }

    protected void onProgress(double progress) {
        if (progress < 0.0) {
            this.progressBar.setIndeterminate(true);
            this.LOGGER.debug("onProgress setIndeterminate " + progress);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue((float)progress);
            NumberFormat defaultFormat = NumberFormat.getPercentInstance();
            defaultFormat.setMinimumFractionDigits(1);
            this.messageLabel.setValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_UPDATE_PROGRESS_CAPTION, new Object[0]) + " " + defaultFormat.format(progress));
            this.LOGGER.debug("onProgress " + progress);
        }
    }

    protected void onProgress(String message) {
        this.messageLabel.setValue(message);
    }

    protected void onProgress(String message, double progress) {
        this.onProgress(message);
        this.onProgress(progress);
    }
}

