/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.services.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import javax.annotation.PostConstruct;
import org.openthinclient.service.apacheds.DirectoryService;
import org.openthinclient.service.common.ServiceManager;
import org.openthinclient.service.dhcp.DHCPService;
import org.openthinclient.service.nfs.NFSService;
import org.openthinclient.syslogd.SyslogService;
import org.openthinclient.tftp.TFTPService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.services.ui.DhcpServiceConfigurationForm;
import org.openthinclient.web.services.ui.ServicePanel;
import org.openthinclient.web.ui.SettingsUI;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="services", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SERVICES_CAPTION", order=20)
public class ServicesView
extends Panel
implements View {
    private static final long serialVersionUID = 7856636768058411222L;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    @Autowired
    private DhcpServiceConfigurationForm dhcpServiceConfigurationForm;
    private final ServicePanel directoryServicePanel;
    private final ServicePanel tftpServicePanel;
    private final ServicePanel syslogServicePanel;
    private final ServicePanel nfsServicePanel;
    private final ServicePanel dhcpServicePanel;

    @Autowired
    public ServicesView(ServiceManager serviceManager) {
        this.directoryServicePanel = new ServicePanel(serviceManager, DirectoryService.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_CAPTION_DIRECTORY, new Object[0]));
        this.tftpServicePanel = new ServicePanel(serviceManager, TFTPService.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_CAPTION_TFTP, new Object[0]));
        this.syslogServicePanel = new ServicePanel(serviceManager, SyslogService.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_CAPTION_SYSLOG, new Object[0]));
        this.nfsServicePanel = new ServicePanel(serviceManager, NFSService.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_CAPTION_NFS, new Object[0]));
        this.dhcpServicePanel = new ServicePanel(serviceManager, DHCPService.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_CAPTION_DHCP, new Object[0]));
        this.setSizeFull();
    }

    @PostConstruct
    private void init() {
        this.setContent(this.buildContent());
    }

    private Component buildContent() {
        HorizontalLayout servicePanels = new HorizontalLayout();
        servicePanels.setStyleName("services-wrap");
        servicePanels.setSpacing(true);
        servicePanels.setMargin(false);
        servicePanels.addComponent((Component)this.directoryServicePanel);
        servicePanels.addComponent((Component)this.tftpServicePanel);
        servicePanels.addComponent((Component)this.syslogServicePanel);
        servicePanels.addComponent((Component)this.nfsServicePanel);
        servicePanels.addComponent((Component)this.dhcpServicePanel);
        VerticalLayout content = new VerticalLayout();
        content.addComponent((Component)servicePanels);
        content.addComponent((Component)this.dhcpServiceConfigurationForm);
        content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_DESCRIPTION, new Object[0]), ContentMode.HTML));
        return content;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.directoryServicePanel.refresh();
        this.tftpServicePanel.refresh();
        this.syslogServicePanel.refresh();
        this.nfsServicePanel.refresh();
        this.dhcpServicePanel.refresh();
        this.dhcpServiceConfigurationForm.refresh();
    }
}

