/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.api.ldif.export.LdifExporterService;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.component.ProfilesListOverviewPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotDeletedException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ProfilesListOverviewPanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractDirectoryObjectView<P extends DirectoryObject>
extends Panel
implements View {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    protected ManagerHome managerHome;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    private RealmService realmService;
    @Autowired
    private ClientService clientService;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    protected IMessageConveyor mc;
    private VerticalLayout clientSettingsVL;
    private CssLayout clientReferencesCL;
    private Component clientReferencesCaption;
    protected ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();
    protected final CssLayout overviewCL;
    private final CssLayout clientCL;

    public AbstractDirectoryObjectView() {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setStyleName("item-view");
        this.setSizeFull();
        CssLayout view = new CssLayout();
        view.addStyleName("maincontent");
        view.setResponsive(true);
        view.setSizeFull();
        this.overviewCL = new CssLayout();
        this.overviewCL.addStyleName("profiles-overview");
        view.addComponent((Component)this.overviewCL);
        this.clientCL = new CssLayout();
        this.clientCL.addStyleName("profile");
        this.clientCL.setSizeFull();
        this.clientSettingsVL = new VerticalLayout();
        this.clientSettingsVL.addStyleName("profile-settings");
        this.clientSettingsVL.setMargin(new MarginInfo(false, false, false, false));
        this.clientSettingsVL.setSizeFull();
        this.clientSettingsVL.setSpacing(false);
        this.clientReferencesCL = new CssLayout();
        this.clientReferencesCL.addStyleName("profile-references");
        this.clientReferencesCL.setVisible(false);
        this.clientReferencesCaption = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_ASSOCIATION, new Object[0]), this::toggleVisibilityClass);
        this.clientReferencesCaption.setPrimaryStyleName("references-caption");
        this.clientCL.addComponents(new Component[]{this.clientSettingsVL, this.clientReferencesCL});
        this.clientCL.setVisible(false);
        view.addComponent((Component)this.clientCL);
        this.setContent((Component)view);
    }

    void toggleVisibilityClass(Button.ClickEvent ev) {
        if (this.getStyleName().contains("expanded")) {
            this.removeStyleName("expanded");
        } else {
            this.addStyleName("expanded");
        }
    }

    public abstract ProfilePanel createProfilePanel(P var1) throws BuildProfileException;

    public abstract ProfileReferencesPanel createReferencesPanel(P var1) throws BuildProfileException;

    public abstract Set<? extends DirectoryObject> getAllItems();

    protected Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(this.getItemClass(), schemaName);
    }

    protected Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(this.getItemClass())).collect(Collectors.toMap(name -> name, name -> this.getSchema((String)name).getLabel()));
    }

    public abstract String getViewName();

    public String getParentViewName() {
        return this.getViewName();
    }

    public abstract ConsoleWebMessages getViewTitleKey();

    protected abstract Class<P> getItemClass();

    protected abstract P newProfile();

    public abstract P getFreshProfile(String var1);

    protected abstract <D extends DirectoryObject> Set<D> getMembers(P var1, Class<D> var2);

    public abstract void save(P var1) throws ProfileNotSavedException;

    public void delete(P profile) throws ProfileNotDeletedException {
        Realm realm = profile.getRealm();
        try {
            realm.getDirectory().delete(profile);
        }
        catch (DirectoryException e) {
            throw new ProfileNotDeletedException("Cannot delete object " + profile, (Exception)((Object)e));
        }
        Audit.logDelete(profile);
    }

    private Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    protected void addOverviewComponent(Component c) {
        this.overviewCL.addComponent(c);
    }

    public void showError(Exception e) {
        this.overviewCL.removeAllComponents();
        this.clientSettingsVL.removeAllComponents();
        this.clientReferencesCL.removeAllComponents();
        String message = e.getCause() instanceof DirectoryException ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_ERROR_DIRECTORY_EXCEPTION, new Object[0]) : e.getLocalizedMessage();
        Label emptyScreenHint = new Label(VaadinIcons.WARNING.getHtml() + "&nbsp;&nbsp;&nbsp;" + this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_ERROR, new Object[0]) + message, ContentMode.HTML);
        emptyScreenHint.setStyleName("errorScreenHint");
        this.clientSettingsVL.addComponent((Component)emptyScreenHint);
    }

    protected <T extends DirectoryObject> void saveReference(P profile, List<Item> values, Set<? extends DirectoryObject> profileAndDirectoryObjects, Class<T> clazz) {
        Set members = this.getMembers(profile, clazz);
        List<Item> oldValues = ProfilePropertiesBuilder.createFilteredItemsFromDO(members, clazz);
        oldValues.forEach(oldItem -> {
            if (values.contains(oldItem)) {
                this.LOGGER.debug("Keep oldValue as member: " + oldItem);
            } else {
                this.LOGGER.debug("Remove oldValue from members: " + oldItem);
                Optional<DirectoryObject> directoryObject = profileAndDirectoryObjects.stream().filter(o -> o.getName().equals(oldItem.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    DirectoryObject object = directoryObject.get();
                    if (object instanceof ClientMetaData) {
                        members.remove(this.getClient(object.getName()));
                    } else {
                        members.remove(object);
                    }
                } else {
                    this.LOGGER.info("DirectoryObject (to remove) not found for " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            if (newValue != null && !oldValues.contains(newValue)) {
                this.LOGGER.debug("Add newValue to members: " + newValue);
                Optional<DirectoryObject> directoryObject = profileAndDirectoryObjects.stream().filter(o -> o.getName().equals(newValue.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    DirectoryObject object = directoryObject.get();
                    if (object instanceof ClientMetaData) {
                        members.add(this.getClient(object.getName()));
                    } else {
                        members.add(object);
                    }
                } else {
                    this.LOGGER.info("DirectoryObject not found for " + newValue);
                }
            }
        });
        this.saveProfile(profile, null);
    }

    public void selectItem(DirectoryObject directoryObject) {
        this.LOGGER.debug("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(this.getViewName(), directoryObject, this.getAllItems());
    }

    public boolean saveProfile(P profile, DirectoryObjectPanelPresenter panelPresenter) {
        try {
            this.save(profile);
            this.LOGGER.info("Profile saved {}", profile);
            if (panelPresenter != null) {
                panelPresenter.setInfo(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_SAVE_SUCCESS, new Object[0]));
            }
            return true;
        }
        catch (Exception e) {
            this.LOGGER.error("Cannot save profile", (Throwable)e);
            if (panelPresenter != null) {
                panelPresenter.setError(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_SAVE_ERROR, new Object[0]) + e.getMessage());
            }
            return false;
        }
    }

    protected abstract void showProfileMetadata(P var1);

    public void showProfileMetadataPanel(ProfilePanel panel) {
        this.overviewCL.setVisible(false);
        this.clientReferencesCL.setVisible(false);
        this.clientCL.setVisible(true);
        this.clientSettingsVL.removeAllComponents();
        this.clientSettingsVL.addComponent((Component)panel);
    }

    protected void addProfileNameAlreadyExistsValidator(OtcPropertyGroup meta) {
        meta.getProperty("name").ifPresent(nameProperty -> nameProperty.getConfiguration().getValidators().add((Validator)new AbstractValidator<String>(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_ALREADY_EXISTS, new Object[0])){

            public ValidationResult apply(String value, ValueContext context) {
                Object directoryObject = AbstractDirectoryObjectView.this.getFreshProfile(value);
                return nameProperty.getInitialValue() == null && directoryObject == null || nameProperty.getInitialValue() != null && nameProperty.getInitialValue().equals(value) && directoryObject != null || nameProperty.getInitialValue() != null && !nameProperty.getInitialValue().equals(value) && directoryObject == null ? ValidationResult.ok() : ValidationResult.error((String)AbstractDirectoryObjectView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_ALREADY_EXISTS, new Object[0]));
            }
        }));
    }

    public ProfilesListOverviewPanelPresenter createOverviewItemlistPanel(ConsoleWebMessages i18nTitleKey, Set items, boolean enabled) {
        ProfilesListOverviewPanel plop = new ProfilesListOverviewPanel(i18nTitleKey, enabled);
        ProfilesListOverviewPanelPresenter plopPresenter = new ProfilesListOverviewPanelPresenter(this, plop, new LdifExporterService(this.realmService.getDefaultRealm().getConnectionDescriptor()));
        ListDataProvider dataProvider = DataProvider.ofCollection((Collection)items);
        dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
        plopPresenter.setDataProvider((ListDataProvider<DirectoryObject>)dataProvider);
        plopPresenter.setVisible(true);
        return plopPresenter;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.LOGGER.debug("enter -> source={}, navigator-state=", event.getSource(), (Object)event.getNavigator().getState());
        String[] params = Optional.ofNullable(event.getParameters()).orElse("").split("/", 2);
        if (params.length > 0) {
            if ("create".equals(params[0])) {
                this.showProfileMetadata(this.newProfile());
            } else if ("register".equals(params[0]) && params.length == 2 && "client_view".equals(event.getViewName())) {
                Client client = new Client();
                client.setMacAddress(params[1]);
                this.showProfileMetadata(client);
            } else if ("edit".equals(params[0]) && params.length == 2 && params[1].length() > 0) {
                P profile = this.getFreshProfile(params[1]);
                if (profile != null) {
                    this.showProfile(profile);
                } else {
                    this.LOGGER.info("No profile found for name '" + params[1] + "'.");
                }
            } else {
                this.showOverview();
            }
        }
    }

    public void showOverview(boolean enabled) {
        ProfilesListOverviewPanelPresenter overviewPanelPresenter = this.createOverviewItemlistPanel(this.getViewTitleKey(), this.getAllItems(), enabled);
        overviewPanelPresenter.setDeleteMandatSupplier(this.createDeleteMandateFunction());
        this.displayOverviewPanel(overviewPanelPresenter.getPanel());
    }

    public void showOverview() {
        this.showOverview(true);
    }

    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return null;
    }

    public void showProfile(P profile) {
        try {
            ProfilePanel profilePanel = this.createProfilePanel(profile);
            ProfileReferencesPanel profileReferencesPanel = this.createReferencesPanel(profile);
            this.displayProfilePanel(profilePanel, profileReferencesPanel);
        }
        catch (BuildProfileException e) {
            this.LOGGER.error("Failed to build profile!", (Throwable)e);
            this.showError(e);
        }
    }

    public void displayOverviewPanel(ProfilesListOverviewPanel overviewPanel) {
        this.clientSettingsVL.setVisible(false);
        this.clientReferencesCL.setVisible(false);
        this.clientCL.setVisible(false);
        this.overviewCL.removeAllComponents();
        this.overviewCL.addComponent((Component)overviewPanel);
        this.overviewCL.setVisible(true);
    }

    public void displayProfilePanel(ProfilePanel profilePanel, ProfileReferencesPanel profileReferencesPanel) {
        this.overviewCL.setVisible(false);
        this.clientCL.setVisible(true);
        this.clientSettingsVL.removeAllComponents();
        this.clientSettingsVL.addComponent((Component)profilePanel);
        this.clientReferencesCL.removeAllComponents();
        if (profileReferencesPanel != null) {
            this.clientReferencesCL.addComponent(this.clientReferencesCaption);
            this.clientReferencesCL.addComponent((Component)profileReferencesPanel);
            this.clientReferencesCL.setVisible(true);
        } else {
            this.clientReferencesCL.setVisible(false);
        }
    }

    public void navigateTo(DirectoryObject directoryObject) {
        Navigator navigator = UI.getCurrent().getNavigator();
        if (directoryObject != null) {
            navigator.navigateTo(this.getViewName() + "/edit/" + directoryObject.getName());
        } else {
            navigator.navigateTo(this.getParentViewName());
        }
    }

    public RealmService getRealmService() {
        return this.realmService;
    }
}

