/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileView<P extends Profile>
extends AbstractDirectoryObjectView<P> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    public void showProfileMetadata(P profile) {
        this.showProfileMetadataPanel(this.createProfileMetadataPanel(profile));
    }

    protected ProfilePanel createProfileMetadataPanel(P profile) {
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_PROFILE_HEADER, new Object[0]), profile.getClass());
        OtcPropertyGroup group = this.createOtcMetaDataPropertyGroup(profile);
        ProfilePanelPresenter ppp = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        ppp.hideCopyButton();
        ppp.hideDeleteButton();
        ppp.setItemGroups(Arrays.asList(group, new OtcPropertyGroup()));
        ppp.onValuesWritten(profilePanel1 -> this.saveValues(ppp, profile));
        return profilePanel;
    }

    private OtcPropertyGroup createOtcMetaDataPropertyGroup(P profile) {
        OtcPropertyGroup group = this.builder.createProfileMetaDataGroup(this.getSchemaNames(), (Profile)profile);
        if (profile.getName() == null || profile.getName().length() == 0) {
            this.addProfileNameAlreadyExistsValidator(group);
        }
        group.getProperty("type").ifPresent(otcProperty -> {
            otcProperty.getConfiguration().setRequired(true);
            otcProperty.getConfiguration().enable();
        });
        return group;
    }

    public void saveValues(ProfilePanelPresenter profilePanelPresenter, P profile) {
        this.LOGGER.debug("Save values for profile: " + profile);
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            block15: {
                String orig;
                String propertyKey;
                block13: {
                    block14: {
                        String current;
                        boolean isPasswordProperty = otcProperty instanceof OtcPasswordProperty;
                        ItemConfiguration bean = otcProperty.getConfiguration();
                        propertyKey = otcProperty.getKey();
                        orig = propertyKey.equals("name") ? profile.getName() : (propertyKey.equals("description") ? profile.getDescription() : (propertyKey.equals("type") && profile.getRealm() != null ? profile.getSchema(profile.getRealm()).getName() : profile.getValueLocal(propertyKey)));
                        String string = current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
                        if (StringUtils.equals((CharSequence)orig, (CharSequence)current)) break block13;
                        if (current == null) break block14;
                        this.LOGGER.debug(" Apply value for " + propertyKey + "=" + (isPasswordProperty ? "***" : orig) + " with new value '" + (isPasswordProperty ? "***" : current) + "'");
                        switch (propertyKey) {
                            case "name": {
                                profile.setName(current);
                                break;
                            }
                            case "description": {
                                profile.setDescription(current);
                                break;
                            }
                            case "type": {
                                profile.setSchema(this.getSchema(current));
                                Schema orgSchema = this.getSchema(otcProperty.getInitialValue());
                                if (orgSchema != null) {
                                    orgSchema.getChildren().forEach(o -> profile.removeValue(o.getName()));
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                profile.setValue(propertyKey, current);
                                break;
                            }
                        }
                        break block15;
                    }
                    if (propertyKey.equals("description")) {
                        this.LOGGER.debug(" Apply null value for description");
                        profile.setDescription(null);
                    } else {
                        this.LOGGER.debug(" Remove empty value for " + propertyKey);
                        profile.removeValue(propertyKey);
                    }
                    break block15;
                }
                this.LOGGER.debug(" Unchanged " + propertyKey + "=" + orig);
            }
        }));
        boolean success = this.saveProfile(profile, profilePanelPresenter);
        if (success) {
            this.selectItem((DirectoryObject)profile);
            this.navigateTo((DirectoryObject)profile);
        }
    }
}

