/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ApplicationGroupView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="application_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_APPLICATION_HEADER", order=30)
@ThemeIcon(value="icon/application.svg")
public final class ApplicationView
extends AbstractProfileView<Application> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationView.class);
    public static final String NAME = "application_view";
    public static final String ICON = "icon/application.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_APPLICATION_HEADER;
    @Autowired
    private ApplicationGroupView applicationGroupView;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationGroupService applicationGroupService;

    @PostConstruct
    public void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<Application> getAllItems() {
        try {
            return this.applicationService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<Application> getItemClass() {
        return Application.class;
    }

    @Override
    public ProfilePanel createProfilePanel(Application profile) throws BuildProfileException {
        Map<String, String> schemaNames = this.getSchemaNames();
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(schemaNames, (Profile)profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), schemaNames.getOrDefault(type, type), Application.class);
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Application profile) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(Application.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = profile.getMembers();
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, ApplicationGroup.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, values -> this.saveApplicationGroupReference(profile, (List<Item>)values), this.getApplicationsForApplicationGroupFunction());
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, User.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, values -> this.saveReference(profile, (List<Item>)values, allUsers, User.class));
        Set userGroups = this.userGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, UserGroup.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), userGroups, values -> this.saveReference(profile, (List<Item>)values, userGroups, UserGroup.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, Client.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, values -> this.saveReference(profile, (List<Item>)values, allClients, Client.class));
        return referencesPanel;
    }

    private void saveApplicationGroupReference(Application application, List<Item> values) {
        Set oldValues = ((Application)this.applicationService.findByName(application.getName())).getMembers();
        LOGGER.debug("Old application-groups: {}", (Object)oldValues);
        oldValues.stream().filter(directoryObject -> directoryObject instanceof ApplicationGroup).forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from application: " + oldItem);
                if (application.getMembers().contains(oldItem)) {
                    application.getMembers().remove(oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            ApplicationGroup applicationGroup1 = (ApplicationGroup)this.applicationGroupService.findByName(newValue.getName());
            if (applicationGroup1 != null) {
                if (!oldValues.contains(applicationGroup1)) {
                    LOGGER.info("Add ApplicationGroup {} as member of {}", (Object)applicationGroup1.getName(), (Object)application);
                    application.getMembers().add(applicationGroup1);
                }
            } else {
                LOGGER.info("ApplicationGroup not found for " + newValue);
            }
        });
        this.applicationService.save((DirectoryObject)application);
    }

    @Override
    protected Application newProfile() {
        return new Application();
    }

    @Override
    public Application getFreshProfile(String profileName) {
        return (Application)this.applicationService.findByName(profileName);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Application profile, Class<D> clazz) {
        return profile.getMembers();
    }

    @Override
    public void save(Application profile) {
        LOGGER.info("Save: " + profile);
        this.applicationService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction() {
        return appGroup -> {
            Optional<ApplicationGroup> first = this.applicationGroupService.findAll().stream().filter(ag -> ag.getName().equals(appGroup.getName())).findFirst();
            if (first.isPresent()) {
                ApplicationGroup applicationGroup = first.get();
                LOGGER.info("ApplicationGroup {} with applications {} loaded.", (Object)applicationGroup.getName(), (Object)applicationGroup.getApplications());
                return applicationGroup.getApplications().stream().map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void showOverview() {
        super.showOverview();
        this.overviewCL.addComponent((Component)this.applicationGroupView.createOverviewItemlistPanel(this.applicationGroupView.getViewTitleKey(), this.applicationGroupView.getAllItems(), true).getPanel());
    }
}

