/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.jamierf.wol.WakeOnLan;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.BorderStyle;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.Audit;
import org.openthinclient.web.component.Popup;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotDeletedException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcMacProperty;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="client_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_CLIENT_HEADER", order=20)
@ThemeIcon(value="icon/thinclient.svg")
public final class ClientView
extends AbstractProfileView<Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientView.class);
    public static final String NAME = "client_view";
    public static final String ICON = "icon/thinclient.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_CLIENT_HEADER;
    private EventBus.SessionEventBus eventBus;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public ClientView(EventBus.SessionEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @PostConstruct
    public void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<ClientMetaData> getAllItems() {
        try {
            long start = System.currentTimeMillis();
            Set all = this.clientService.findAllClientMetaData();
            LOGGER.debug("GetAllItems clients took: " + (System.currentTimeMillis() - start) + "ms");
            return all;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<Client> getItemClass() {
        return Client.class;
    }

    @Override
    public ProfilePanel createProfilePanel(Client profile) throws BuildProfileException {
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), (Profile)profile);
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT, new Object[0]), Client.class);
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        if (!"00:00:00:00:00:00".equals(profile.getMacAddress())) {
            String ip = profile.getIpHostNumber();
            if (ip != null && !ip.isEmpty() && !ip.equals("0.0.0.0")) {
                presenter.addPanelCaptionComponent(this.createIPButton(profile));
            }
            presenter.addPanelCaptionComponent(this.createWOLButton(profile));
            presenter.addPanelCaptionComponent(this.createVNCButton(profile));
            presenter.addPanelCaptionComponent(this.createLOGButton(profile));
        }
        presenter.hideCopyButton();
        otcPropertyGroups.remove(0);
        otcPropertyGroups.add(0, this.createClientMetadataPropertyGroup(profile, presenter));
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Client client) {
        Set locationPrinters;
        Set hwtypeDevices;
        Location location;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(Client.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        HardwareType hwtype = client.getHardwareType();
        if (hwtype != null) {
            refPresenter.showReference(Collections.singleton(hwtype), this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE, new Object[0]));
        }
        if ((location = client.getLocation()) != null) {
            refPresenter.showReference(Collections.singleton(location), this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION, new Object[0]));
        }
        Set allApplications = this.applicationService.findAll();
        refPresenter.showReference(client.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, values -> this.saveReference(client, (List<Item>)values, allApplications, Application.class));
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)client.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, values -> this.saveReference(client, (List<Item>)values, allApplicationGroups, ApplicationGroup.class), this.getApplicationsForApplicationGroupFunction(client));
        Set devices = client.getDevices();
        Set allDevices = this.deviceService.findAll();
        refPresenter.showReference(devices, this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICE_HEADER, new Object[0]), allDevices, values -> this.saveReference(client, (List<Item>)values, allDevices, Device.class));
        if (hwtype != null && (hwtypeDevices = hwtype.getDevices()).size() > 0) {
            refPresenter.showReferenceAddendum(hwtypeDevices, this.mc.getMessage((Enum)ConsoleWebMessages.UI_FROM_HWTYPE_HEADER, new Object[0]));
        }
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(client.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, values -> this.saveReference(client, (List<Item>)values, allPrinters, Printer.class));
        if (location != null && (locationPrinters = location.getPrinters()).size() > 0) {
            refPresenter.showReferenceAddendum(locationPrinters, this.mc.getMessage((Enum)ConsoleWebMessages.UI_FROM_LOCATION_HEADER, new Object[0]));
        }
        return referencesPanel;
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction(Client client) {
        return item -> {
            Optional<ApplicationGroup> first = client.getApplicationGroups().stream().filter(ag -> ag.getName().equals(item.getName())).findFirst();
            if (first.isPresent()) {
                return first.get().getApplications().stream().map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    private Component createIPButton(Client profile) {
        Button button = new Button();
        button.addStyleNames(new String[]{"ip", "copy-on-click"});
        button.setCaption(profile.getIpHostNumber());
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_IP, new Object[0]));
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        return button;
    }

    private Component createWOLButton(Client profile) {
        Button button = new Button();
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_WOL, new Object[0]));
        button.setIcon((Resource)VaadinIcons.POWER_OFF);
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        button.addStyleName("icon-only");
        button.addClickListener((Button.ClickListener & Serializable)ev -> this.wakeOnLan(profile));
        return button;
    }

    private Component createVNCButton(Client profile) {
        Button button = new Button();
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_VNC, new Object[0]));
        button.setIcon((Resource)VaadinIcons.DESKTOP);
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        button.addStyleName("icon-only");
        button.addClickListener((Button.ClickListener & Serializable)ev -> this.openNoVncInNewBrowserWindow(profile.getName()));
        return button;
    }

    private Component createLOGButton(Client profile) {
        Button button = new Button();
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_CLIENTLOG, new Object[0]));
        button.setIcon((Resource)VaadinIcons.FILE_TEXT_O);
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        button.addStyleName("icon-only");
        button.addClickListener((Button.ClickListener & Serializable)ev -> this.showClientLogs(profile));
        return button;
    }

    @Override
    protected ProfilePanel createProfileMetadataPanel(Client p) {
        Client profile = p;
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_CLIENT_HEADER, new Object[0]), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.hideCopyButton();
        presenter.hideDeleteButton();
        OtcPropertyGroup configuration = this.createClientMetadataPropertyGroup(profile, presenter);
        presenter.setItemGroups(Arrays.asList(configuration, new OtcPropertyGroup()));
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, p));
        return profilePanel;
    }

    private OtcPropertyGroup createClientMetadataPropertyGroup(Client profile, ProfilePanelPresenter presenter) {
        OtcPropertyGroup configuration = this.builder.createDirectoryObjectMetaDataGroup((DirectoryObject)profile);
        this.addProfileNameAlreadyExistsValidator(configuration);
        configuration.getProperty("name").ifPresent(nameProperty -> nameProperty.getConfiguration().addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_THINCLIENT_NAME_REGEXP, new Object[0]), "^[a-zA-Z0-9][a-zA-Z0-9\\-\\.]+[a-zA-Z0-9]$")));
        final String mac = profile.getMacAddress();
        OtcMacProperty macaddress = new OtcMacProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC_TIP, new Object[0]), "macaddress", profile.getMacAddress(), null, this.unrecognizedClientService);
        ItemConfiguration macaddressConfiguration = new ItemConfiguration("macaddress", mac);
        macaddressConfiguration.setRequired(mac == null);
        macaddressConfiguration.addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC_VALIDATOR_ADDRESS, new Object[0]), "^\\s*([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})\\s*$"));
        macaddressConfiguration.addValidator((Validator)new Validator<String>(){

            public ValidationResult apply(String value, ValueContext context) {
                Optional client;
                if (value != null && !value.equalsIgnoreCase(mac) && (client = ClientView.this.clientService.findByHwAddress(value.trim()).stream().findFirst()).isPresent()) {
                    return ValidationResult.error((String)ClientView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_MAC_ADDRESS_ALREADY_EXISTS, new Object[]{((Client)client.get()).getName()}));
                }
                return ValidationResult.ok();
            }
        });
        macaddress.setConfiguration(macaddressConfiguration);
        configuration.addProperty(macaddress);
        boolean isNew = profile.getDn() == null;
        Location location = profile.getLocation();
        Set allLocations = this.locationService.findAll();
        String selectedLocationDn = null;
        if (location != null) {
            selectedLocationDn = location.getDn();
        } else if (isNew && allLocations.size() == 1) {
            selectedLocationDn = ((Location)allLocations.stream().findFirst().get()).getDn();
        }
        OtcOptionProperty locationProp = new OtcOptionProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION, new Object[0]), null, "location", selectedLocationDn, null, allLocations.stream().map(o -> new SelectOption(o.getName(), o.getDn())).collect(Collectors.toList()));
        ItemConfiguration locationConfig = new ItemConfiguration("location", location != null ? location.getDn() : null);
        locationConfig.setRequired(true);
        ((OtcProperty)locationProp).setConfiguration(locationConfig);
        configuration.addProperty(locationProp);
        HardwareType hardwareType = profile.getHardwareType();
        Set allHardwareTypes = this.hardwareTypeService.findAll();
        String selectedHardwareTypeDn = null;
        if (location != null) {
            selectedHardwareTypeDn = location.getDn();
        } else if (isNew && allHardwareTypes.size() == 1) {
            selectedHardwareTypeDn = ((HardwareType)allHardwareTypes.stream().findFirst().get()).getDn();
        }
        OtcOptionProperty hwProp = new OtcOptionProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE, new Object[0]), null, "hwtype", selectedHardwareTypeDn, null, allHardwareTypes.stream().map(o -> new SelectOption(o.getName(), o.getDn())).collect(Collectors.toList()));
        ItemConfiguration hwtypeConfig = new ItemConfiguration("hwtype", hardwareType != null ? hardwareType.getDn() : null);
        hwtypeConfig.setRequired(true);
        ((OtcProperty)hwProp).setConfiguration(hwtypeConfig);
        configuration.addProperty(hwProp);
        return configuration;
    }

    @Override
    public void saveValues(ProfilePanelPresenter profilePanelPresenter, Client profile) {
        LOGGER.debug("Save values for client: " + profile);
        Client client = profile;
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            String org;
            String propertyKey;
            ItemConfiguration bean = otcProperty.getConfiguration();
            switch (propertyKey = otcProperty.getKey()) {
                case "iphostnumber": {
                    org = client.getIpHostNumber();
                    break;
                }
                case "macaddress": {
                    org = client.getMacAddress();
                    break;
                }
                case "location": {
                    org = client.getLocation() != null ? client.getLocation().getDn() : null;
                    break;
                }
                case "hwtype": {
                    org = client.getHardwareType() != null ? client.getHardwareType().getDn() : null;
                    break;
                }
                case "type": {
                    try {
                        org = client.getSchema(client.getRealm()).getName();
                    }
                    catch (Exception e) {
                        LOGGER.warn(" Cannot load schema for " + client.getName() + " to obtain original value for property 'type', using null.");
                        org = null;
                    }
                    break;
                }
                case "name": {
                    org = client.getName();
                    break;
                }
                case "description": {
                    org = client.getDescription();
                    break;
                }
                default: {
                    org = client.getValue(propertyKey);
                }
            }
            String current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
            if (!StringUtils.equals((CharSequence)org, current)) {
                if (current != null) {
                    LOGGER.debug(" Apply value for " + propertyKey + "=" + org + " with new value '" + current + "'");
                    switch (propertyKey) {
                        case "iphostnumber": {
                            client.setIpHostNumber(current);
                            break;
                        }
                        case "macaddress": {
                            client.setMacAddress(current != null ? current : "");
                            break;
                        }
                        case "location": {
                            client.setLocation(this.locationService.findAll().stream().filter(l -> l.getDn().equals(current)).findFirst().get());
                            break;
                        }
                        case "hwtype": {
                            client.setHardwareType(this.hardwareTypeService.findAll().stream().filter(h -> h.getDn().equals(current)).findFirst().get());
                            break;
                        }
                        case "type": {
                            client.setSchema(this.getSchema(current));
                            break;
                        }
                        case "name": {
                            client.setName(current);
                            break;
                        }
                        case "description": {
                            client.setDescription(current);
                            break;
                        }
                        default: {
                            client.setValue(propertyKey, current);
                            break;
                        }
                    }
                } else if (propertyKey.equals("description")) {
                    LOGGER.debug(" Apply null value for description");
                    client.setDescription(null);
                } else {
                    LOGGER.debug(" Remove empty value for " + propertyKey);
                    client.removeValue(propertyKey);
                }
            } else {
                LOGGER.debug(" Unchanged " + propertyKey + "=" + org);
            }
        }));
        boolean success = this.saveProfile(client, profilePanelPresenter);
        if (success) {
            this.selectItem((DirectoryObject)client);
            this.navigateTo((DirectoryObject)profile);
        }
    }

    @Override
    protected Client newProfile() {
        return new Client();
    }

    @Override
    public Client getFreshProfile(String name) {
        long start = System.currentTimeMillis();
        Client profile = (Client)this.clientService.findByName(name);
        LOGGER.debug("GetFreshProfile for client took: " + (System.currentTimeMillis() - start) + "ms");
        return profile;
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Client profile, Class<D> clazz) {
        if (clazz == ClientGroup.class) {
            return profile.getClientGroups();
        }
        if (clazz == Device.class) {
            return profile.getDevices();
        }
        if (clazz == Printer.class) {
            return profile.getPrinters();
        }
        if (clazz == Application.class) {
            return profile.getApplications();
        }
        if (clazz == ApplicationGroup.class) {
            return profile.getApplicationGroups();
        }
        return Collections.emptySet();
    }

    @Override
    public void save(Client profile) throws ProfileNotSavedException {
        LOGGER.info("Save client: " + profile);
        this.clientService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
        String macAddress = profile.getMacAddress();
        Optional<UnrecognizedClient> optionalUnrecognizedClient = this.unrecognizedClientService.findAll().stream().filter(unrecognizedClient -> unrecognizedClient.getMacAddress().equals(macAddress)).findFirst();
        if (optionalUnrecognizedClient.isPresent()) {
            Realm realm = optionalUnrecognizedClient.get().getRealm();
            try {
                realm.getDirectory().delete((Object)optionalUnrecognizedClient.get());
            }
            catch (DirectoryException e) {
                throw new ProfileNotSavedException("Cannot delete object " + profile, (Exception)((Object)e));
            }
        }
        this.eventBus.publish((Object)this, (Object)new DashboardEvent.ClientCountChangeEvent());
    }

    @Override
    public void delete(Client profile) throws ProfileNotDeletedException {
        String mac = profile.getMacAddress();
        Path logDir = this.managerHome.getLocation().toPath().resolve("logs").resolve("syslog");
        File[] logFiles = logDir.toFile().listFiles((d, name) -> name.startsWith(mac));
        if (logFiles != null) {
            for (File file : logFiles) {
                file.delete();
            }
        }
        super.delete(profile);
        this.eventBus.publish((Object)this, (Object)new DashboardEvent.ClientCountChangeEvent());
    }

    private void showClientLogs(Client profile) {
        Path logs = this.managerHome.getLocation().toPath().resolve("logs").resolve("syslog");
        new FileContentWindow(logs, profile.getName(), profile.getMacAddress()).open();
    }

    private void wakeOnLan(Client profile) {
        try {
            String macAddress = profile.getMacAddress();
            LOGGER.info("Sending WOL packet to " + macAddress);
            WakeOnLan.wake((String)macAddress);
            Notification.show((String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_WOL_SUCCESS, new Object[0]));
        }
        catch (Exception ex) {
            LOGGER.error("Failed to send WOL packet", (Throwable)ex);
            Notification.show((String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_WOL_ERROR, new Object[0]), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
    }

    private void openNoVncInNewBrowserWindow(String clientName) {
        String ipHostNumber = this.getFreshProfile(clientName).getIpHostNumber();
        boolean isNoVNCConsoleEncrypted = false;
        String noVNCConsolePort = "5900";
        String noVNCConsoleAutoconnect = "true";
        String noVNCConsoleAllowfullscreen = "true";
        ExternalResource tr = new ExternalResource("/VAADIN/themes/openthinclient/novnc/vnc.html?host=" + ipHostNumber + "&port=" + noVNCConsolePort + "&encrypt=" + (isNoVNCConsoleEncrypted ? "1" : "0") + "&allowfullscreen=" + noVNCConsoleAllowfullscreen + "&autoconnect=" + noVNCConsoleAutoconnect);
        Page.getCurrent().open(tr.getURL(), "_blank", 800, 600, BorderStyle.DEFAULT);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    class FileContentWindow
    extends Popup {
        private final int MAX_DISPLAY_LINES = 2048;
        private final int MAX_MISSING_LINES = 15;
        private final List<String> FILE_READ_ERROR;

        public FileContentWindow(Path logDir, String name, String macAddress) {
            super(ClientView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_LOG_CAPTION, new Object[]{name, macAddress}), "logview");
            this.MAX_DISPLAY_LINES = 2048;
            this.MAX_MISSING_LINES = 15;
            this.FILE_READ_ERROR = new ArrayList<String>();
            this.setWidth("642px");
            this.setMaximized(true);
            ArrayList<String> lines = new ArrayList<String>();
            int linesLeft = 2048;
            Iterator lineChunks = this.readLogLines(logDir.toAbsolutePath(), macAddress).iterator();
            while (lineChunks.hasNext() && linesLeft > 15) {
                List srcLines = (List)lineChunks.next();
                if (srcLines == this.FILE_READ_ERROR) {
                    if (lines.size() > 0) break;
                    this.setMessage(ConsoleWebMessages.UI_THINCLIENT_LOG_ERROR, new Object[0]);
                    return;
                }
                ListIterator lineIter = srcLines.listIterator(srcLines.size());
                while (lineIter.hasPrevious() && linesLeft > 0) {
                    String[] parts = StringEscapeUtils.escapeHtml((String)((String)lineIter.previous())).split("(?! +)(?<= )", 6);
                    if (parts.length < 6 || !parts[3].startsWith(macAddress)) continue;
                    --linesLeft;
                    StringBuilder line = new StringBuilder();
                    line.append(String.format("<div class=\"logline %s\">", parts[2].trim())).append(parts[0]).append(parts[1]).append(parts[2]).append(parts[5]).append("</div>");
                    lines.add(0, line.toString());
                }
            }
            if (lines.size() > 0) {
                this.addContent(new Component[]{new Label(String.join((CharSequence)"\n", lines), ContentMode.HTML)});
            } else {
                this.setMessage(ConsoleWebMessages.UI_THINCLIENT_LOG_EMPTY, new Object[0]);
            }
        }

        private Stream<List<String>> readLogLines(Path logDir, String macaddress) {
            Stream<Object> logLines;
            Path logPath = logDir.resolve(String.format("%s.log", macaddress));
            if (logPath.toFile().exists()) {
                try {
                    logLines = Stream.of(Files.readAllLines(logPath));
                }
                catch (IOException ex) {
                    LOGGER.error(String.format("Failed to read from log file %s", logPath), (Throwable)ex);
                    return Stream.of(this.FILE_READ_ERROR);
                }
            } else {
                logLines = Stream.empty();
            }
            String[] zipFileNames = logDir.toFile().list((d, name) -> name.startsWith(macaddress) && name.endsWith(".zip"));
            if (zipFileNames == null) {
                LOGGER.error("Could not list files in {}", (Object)logDir);
                return Stream.concat(logLines, Stream.of(this.FILE_READ_ERROR));
            }
            return Stream.concat(logLines, Stream.of(zipFileNames).sorted(Comparator.reverseOrder()).map(logDir::resolve).map(this::readLinesfromZip));
        }

        private List<String> readLinesfromZip(Path filePath) {
            try {
                ZipFile zipFile = new ZipFile(filePath.toFile());
                if (zipFile.size() != 1) {
                    LOGGER.error("Unexpected amount of files ({}) in zipped syslog {}", (Object)zipFile.size(), (Object)zipFile.getName());
                    return Collections.emptyList();
                }
                ZipEntry zipEntry = zipFile.entries().nextElement();
                return new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry))).lines().collect(Collectors.toList());
            }
            catch (IOException ex) {
                LOGGER.error(String.format("Failed to read from log file %s", filePath), (Throwable)ex);
                return this.FILE_READ_ERROR;
            }
        }

        private void setMessage(ConsoleWebMessages messageKey, Object ... args) {
            Label messageLabel = new Label(ClientView.this.mc.getMessage((Enum)messageKey, args));
            messageLabel.addStyleName("message");
            this.addContent(new Component[]{messageLabel});
        }
    }
}

