/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="hardwaretype_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_HWTYPE_HEADER", order=70)
@ThemeIcon(value="icon/hardwaretype.svg")
public final class HardwaretypeView
extends AbstractProfileView<HardwareType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwaretypeView.class);
    public static final String NAME = "hardwaretype_view";
    public static final String ICON = "icon/hardwaretype.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_HWTYPE_HEADER;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<HardwareType> getAllItems() {
        try {
            return this.hardwareTypeService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<HardwareType> getItemClass() {
        return HardwareType.class;
    }

    @Override
    public ProfilePanel createProfilePanel(HardwareType profile) throws BuildProfileException {
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), (Profile)profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE, new Object[0]), HardwareType.class);
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.setDeleteMandate(this.createDeleteMandateFunction());
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(HardwareType hardwareType) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(HardwareType.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allDevices = this.deviceService.findAll();
        refPresenter.showReference(hardwareType.getDevices(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICE_HEADER, new Object[0]), allDevices, values -> this.saveReference(hardwareType, (List<Item>)values, allDevices, Device.class));
        refPresenter.showReference(hardwareType.getMembers(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]));
        return referencesPanel;
    }

    @Override
    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return directoryObject -> {
            HardwareType hwtype = (HardwareType)directoryObject;
            if (hwtype.getMembers().size() > 0) {
                return new DeleteMandate(false, this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_HWTYPE_DENIED, new Object[]{hwtype.getName()}));
            }
            return new DeleteMandate(true, "");
        };
    }

    @Override
    protected HardwareType newProfile() {
        return new HardwareType();
    }

    @Override
    public HardwareType getFreshProfile(String name) {
        return (HardwareType)this.hardwareTypeService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(HardwareType profile, Class<D> clazz) {
        if (clazz == Device.class) {
            return profile.getDevices();
        }
        return profile.getMembers();
    }

    @Override
    public void save(HardwareType profile) {
        LOGGER.info("Save: " + profile);
        this.hardwareTypeService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

