/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="location_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_LOCATION_HEADER", order=80)
@ThemeIcon(value="icon/location.svg")
public final class LocationView
extends AbstractProfileView<Location> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationView.class);
    public static final String NAME = "location_view";
    public static final String ICON = "icon/location.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_LOCATION_HEADER;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private PrinterService printerService;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<Location> getAllItems() {
        try {
            return this.locationService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<Location> getItemClass() {
        return Location.class;
    }

    @Override
    public ProfilePanel createProfilePanel(Location profile) throws BuildProfileException {
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), (Profile)profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION, new Object[0]), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.setDeleteMandate(this.createDeleteMandateFunction());
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Location location) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(Location.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(location.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, values -> this.saveReference(location, (List<Item>)values, allPrinters, Printer.class));
        refPresenter.showReference(this.clientService.findByLocation(location.getName()), this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]));
        return referencesPanel;
    }

    @Override
    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return directoryObject -> {
            Location location = (Location)directoryObject;
            boolean optionalClient = this.clientService.findAll().stream().anyMatch(client -> client.getLocation() != null && client.getLocation().equals((Object)location));
            if (optionalClient) {
                return new DeleteMandate(false, this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_LOCATION_DENIED, new Object[]{location.getName()}));
            }
            return new DeleteMandate(true, "");
        };
    }

    @Override
    protected Location newProfile() {
        return new Location();
    }

    @Override
    public Location getFreshProfile(String name) {
        return (Location)this.locationService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Location profile, Class<D> clazz) {
        return profile.getPrinters();
    }

    @Override
    public void save(Location profile) {
        LOGGER.info("Save: " + profile);
        this.locationService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

