/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="printer_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_PRINTER_HEADER", order=60)
@ThemeIcon(value="icon/printer.svg")
public final class PrinterView
extends AbstractProfileView<Printer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrinterView.class);
    public static final String NAME = "printer_view";
    public static final String ICON = "icon/printer.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_PRINTER_HEADER;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private UserService userService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<Printer> getAllItems() {
        try {
            return this.printerService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<Printer> getItemClass() {
        return Printer.class;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public ProfilePanel createProfilePanel(Printer profile) throws BuildProfileException {
        Map<String, String> schemaNames = this.getSchemaNames();
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(schemaNames, (Profile)profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), schemaNames.getOrDefault(type, type), Printer.class);
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Printer printer) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(Printer.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = printer.getMembers();
        Set allLocations = this.locationService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, Location.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION_HEADER, new Object[0]), allLocations, values -> this.saveReference(printer, (List<Item>)values, allLocations, Location.class));
        Set allUsers = this.userService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, User.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, values -> this.saveReference(printer, (List<Item>)values, allUsers, User.class));
        Set userGroups = this.userGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, UserGroup.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), userGroups, values -> this.saveReference(printer, (List<Item>)values, userGroups, UserGroup.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, Client.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, values -> this.saveReference(printer, (List<Item>)values, allClients, Client.class));
        return referencesPanel;
    }

    @Override
    protected Printer newProfile() {
        return new Printer();
    }

    @Override
    public Printer getFreshProfile(String name) {
        return (Printer)this.printerService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Printer profile, Class<D> clazz) {
        return profile.getMembers();
    }

    @Override
    public void save(Printer profile) {
        LOGGER.info("Save: " + profile);
        this.printerService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }
}

