/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;

public class ProfilePanel
extends CssLayout {
    private VerticalLayout rows;
    private CssLayout panelCaption;
    private AbstractLayout panelButtons;
    private Button copyAction;
    private Button deleteProfileAction;
    private Button contextInfoButton;
    private Label contextInfoLabel;
    IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private Label infoLabel;
    private NativeButton save;
    private NativeButton reset;

    public ProfilePanel(String title, Class<? extends DirectoryObject> clazz) {
        this(title, "", clazz);
    }

    public ProfilePanel(String title, String subtitle, Class<? extends DirectoryObject> clazz) {
        this.addStyleName("card");
        this.panelCaption = new CssLayout();
        this.panelCaption.addStyleName("settings-caption");
        CssLayout titleLayout = new CssLayout();
        titleLayout.setStyleName("settings-title");
        titleLayout.addComponents(new Component[]{new Label(title), new Label(subtitle)});
        this.panelCaption.addComponent((Component)titleLayout);
        this.panelButtons = new CssLayout();
        this.panelButtons.addStyleName("panelButtons");
        this.panelCaption.addComponent((Component)this.panelButtons);
        this.copyAction = this.addPanelButton((Resource)VaadinIcons.COPY_O, ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_COPY);
        this.deleteProfileAction = this.addPanelButton((Resource)VaadinIcons.TRASH, ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_DELETE);
        this.contextInfoButton = this.addPanelButton(null);
        this.contextInfoButton.addStyleName("context-info-button");
        this.contextInfoButton.setVisible(false);
        this.contextInfoLabel = new Label(null, ContentMode.HTML);
        this.contextInfoLabel.addStyleName("context-info-label");
        this.panelCaption.addComponent((Component)this.contextInfoLabel);
        this.addComponent((Component)this.panelCaption);
        this.rows = new VerticalLayout();
        this.addComponent((Component)this.rows);
        this.rows.setMargin(false);
        this.rows.setSpacing(false);
        this.rows.setStyleName("panelRows");
        this.setStyleName("profilePanel");
        this.addStyleName("formPanel_" + clazz.getSimpleName().toLowerCase());
        this.addComponent((Component)this.createActionsBar());
    }

    public Button addPanelButton(Resource icon) {
        return this.addPanelButton(icon, null);
    }

    public Button addPanelButton(Resource icon, ConsoleWebMessages description) {
        Button button = new Button();
        if (description != null) {
            button.setDescription(this.mc.getMessage((Enum)description, new Object[0]));
        }
        button.setIcon(icon);
        button.addStyleNames(new String[]{"borderless-colored", "icon-only"});
        this.panelCaption.addComponent((Component)button);
        return button;
    }

    public void addPanelCaptionComponent(Component component) {
        this.panelButtons.addComponent(component);
    }

    private HorizontalLayout createActionsBar() {
        this.save = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]));
        this.save.addStyleName("profile_save");
        this.save.setEnabled(false);
        this.reset = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_RESET, new Object[0]));
        this.reset.addStyleName("profile_reset");
        this.infoLabel = new Label();
        this.infoLabel.setCaption("");
        this.infoLabel.setVisible(true);
        this.infoLabel.setStyleName("propertyLabel");
        this.infoLabel.addStyleName("itemGroupInfoLabel");
        HorizontalLayout actions = new HorizontalLayout();
        actions.setSizeFull();
        actions.addComponents(new Component[]{this.reset, this.save});
        HorizontalLayout proprow = new HorizontalLayout();
        proprow.setStyleName("property-action");
        proprow.addComponent((Component)this.infoLabel);
        proprow.addComponent((Component)actions);
        return proprow;
    }

    public void setError(String caption) {
        this.infoLabel.setCaption(caption);
        this.infoLabel.removeStyleName("form_success");
        this.infoLabel.addStyleName("form_error");
        this.infoLabel.setVisible(true);
    }

    public void setInfo(String caption) {
        this.infoLabel.setCaption(caption);
        this.infoLabel.removeStyleName("form_error");
        this.infoLabel.addStyleName("form_success");
        this.infoLabel.setVisible(true);
    }

    public void setContextInfo(String tip) {
        this.contextInfoLabel.setValue(tip);
        this.contextInfoButton.setVisible(tip != null);
    }

    public Button getCopyAction() {
        return this.copyAction;
    }

    public Button getDeleteProfileAction() {
        return this.deleteProfileAction;
    }

    public VerticalLayout getRows() {
        return this.rows;
    }

    public Button getSaveButton() {
        return this.save;
    }

    public Button getResetButton() {
        return this.reset;
    }

    public void setDisabledMode() {
        this.save.setEnabled(false);
        this.reset.setEnabled(false);
    }
}

