/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.annotation.SpringView;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="realm_settings_view", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SETTINGS_HEADER", order=10)
public final class RealmSettingsView
extends AbstractProfileView<Realm> {
    public static final String NAME = "realm_settings_view";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_SETTINGS_HEADER;
    private static final Logger LOGGER = LoggerFactory.getLogger(RealmSettingsView.class);
    @Autowired
    @Qualifier(value="settingsSideBar")
    private OTCSideBar settingsSideBar;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    @Override
    public Set<Realm> getAllItems() {
        try {
            Set allRealms = this.getRealmService().findAllRealms();
            HashSet<Realm> hashSet = new HashSet<Realm>();
            hashSet.addAll(allRealms);
            return hashSet;
        }
        catch (Exception e) {
            LOGGER.error("Cannot load realm", (Throwable)e);
            this.showError(e);
            return new HashSet<Realm>();
        }
    }

    @Override
    protected Class<Realm> getItemClass() {
        return Realm.class;
    }

    @Override
    public ProfilePanel createProfilePanel(Realm profile) throws BuildProfileException {
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), (Profile)profile);
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SETTINGS_HEADER, new Object[0]), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.hideCopyButton();
        presenter.hideDeleteButton();
        otcPropertyGroups.get(0).removeProperty("name");
        otcPropertyGroups.get(0).removeProperty("type");
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Realm realm) {
        return null;
    }

    @Override
    protected Realm newProfile() {
        return new Realm();
    }

    @Override
    public Realm getFreshProfile(String name) {
        Set allRealms = this.getRealmService().findAllRealms();
        Optional<Realm> first = allRealms.stream().filter(realm -> realm.getName().equals(name)).findFirst();
        if (first.isPresent()) {
            Realm realm2 = first.get();
            try {
                realm2.refresh();
            }
            catch (DirectoryException e) {
                LOGGER.error("Failed to refresh realm: " + e.getMessage(), (Throwable)e);
            }
            return realm2;
        }
        return new Realm();
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Realm profile, Class<D> clazz) {
        return Collections.emptySet();
    }

    @Override
    public void save(Realm profile) throws ProfileNotSavedException {
        LOGGER.info("Save realm-settings: " + profile);
        try {
            profile.getDirectory().save((Object)profile);
            profile.refresh();
            Audit.logSave("Realm settings", new String[0]);
        }
        catch (DirectoryException e) {
            throw new ProfileNotSavedException("Cannot save object " + profile, (Exception)((Object)e));
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.settingsSideBar));
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        LOGGER.info(this.getViewName() + ".enter(), load RealmConfiguration and update view.");
        Realm realmConfiguration = this.getFreshProfile("RealmConfiguration");
        this.showProfile(realmConfiguration);
    }
}

