/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.UserGroupView;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="user_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_USER_HEADER", order=40)
@ThemeIcon(value="icon/user.svg")
public final class UserView
extends AbstractDirectoryObjectView<User> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserView.class);
    public static final String NAME = "user_view";
    public static final String ICON = "icon/user.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_USER_HEADER;
    @Autowired
    private UserGroupView userGroupView;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    private boolean secondaryDirectory = false;

    @PostConstruct
    private void setup() {
        this.secondaryDirectory = "secondary".equals(this.getRealmService().getDefaultRealm().getValue("UserGroupSettings.DirectoryVersion"));
        this.addStyleName(NAME);
    }

    @Override
    public Set<User> getAllItems() {
        try {
            Set users = this.userService.findAll();
            this.getRealmService().findAllRealms().forEach(realm -> users.removeAll(realm.getAdministrators().getMembers()));
            return users;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<User> getItemClass() {
        return User.class;
    }

    @Override
    public ProfilePanel createProfilePanel(User profile) {
        return this.createUserProfilePanel(profile, false);
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(User user) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(User.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set userGroups = user.getUserGroups();
        Set allUserGroups = this.userGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)userGroups, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), allUserGroups, values -> this.saveReference(user, (List<Item>)values, allUserGroups, UserGroup.class), null);
        Set allApplications = this.applicationService.findAll();
        Consumer<List<Item>> profileReferenceChangeConsumer = null;
        if (!this.secondaryDirectory) {
            profileReferenceChangeConsumer = values -> this.saveReference(user, (List<Item>)values, allApplications, Application.class);
        }
        refPresenter.showReference(user.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, profileReferenceChangeConsumer);
        Set userGroupsWithApplications = userGroups.stream().filter(group -> group.getApplications().size() > 0).collect(Collectors.toSet());
        if (userGroupsWithApplications.size() > 0) {
            refPresenter.showReferenceAddendum(userGroupsWithApplications, this.mc.getMessage((Enum)ConsoleWebMessages.UI_FROM_USERGROUP_HEADER, new Object[0]), this.ApplicationsFromUserGroupFunction(user));
        }
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)user.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, values -> this.saveReference(user, (List<Item>)values, allApplicationGroups, ApplicationGroup.class), this.getApplicationsForApplicationGroupFunction(user));
        Set userGroupsWithApplicationGroups = userGroups.stream().filter(group -> group.getApplicationGroups().size() > 0).collect(Collectors.toSet());
        if (userGroupsWithApplicationGroups.size() > 0) {
            Set appGroups = userGroupsWithApplicationGroups.stream().flatMap(userGroup -> userGroup.getApplicationGroups().stream()).collect(Collectors.toSet());
            refPresenter.showReferenceAddendum(appGroups, this.mc.getMessage((Enum)ConsoleWebMessages.UI_FROM_USERGROUP_HEADER, new Object[0]), this.getApplicationsForUserGroupApplicationGroupFunction(user));
        }
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(user.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, values -> this.saveReference(user, (List<Item>)values, allPrinters, Printer.class));
        Set userGroupsWithPrinters = userGroups.stream().filter(group -> group.getPrinters().size() > 0).collect(Collectors.toSet());
        if (userGroupsWithPrinters.size() > 0) {
            refPresenter.showReferenceAddendum(userGroupsWithPrinters, this.mc.getMessage((Enum)ConsoleWebMessages.UI_FROM_USERGROUP_HEADER, new Object[0]), this.PrintersFromUserGroupFunction(user));
        }
        return referencesPanel;
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction(User user) {
        return item -> user.getApplicationGroups().stream().filter(group -> group.getName().equals(item.getName())).findFirst().map(group -> ProfilePropertiesBuilder.createItems(group.getApplications())).orElse(Collections.emptyList());
    }

    private Function<Item, List<Item>> ApplicationsFromUserGroupFunction(User user) {
        return item -> user.getUserGroups().stream().filter(group -> group.getName().equals(item.getName())).findFirst().map(group -> ProfilePropertiesBuilder.createItems(group.getApplications())).orElse(Collections.emptyList());
    }

    private Function<Item, List<Item>> getApplicationsForUserGroupApplicationGroupFunction(User user) {
        return item -> user.getUserGroups().stream().flatMap(userGroup -> userGroup.getApplicationGroups().stream()).filter(group -> group.getName().equals(item.getName())).findFirst().map(group -> ProfilePropertiesBuilder.createItems(group.getApplications())).orElse(Collections.emptyList());
    }

    private Function<Item, List<Item>> PrintersFromUserGroupFunction(User user) {
        return item -> user.getUserGroups().stream().filter(group -> group.getName().equals(item.getName())).findFirst().map(group -> ProfilePropertiesBuilder.createItems(group.getPrinters())).orElse(Collections.emptyList());
    }

    private OtcPropertyGroup createUserMetadataPropertyGroup(User user) {
        OtcPropertyGroup configuration = new OtcPropertyGroup();
        OtcTextProperty name = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_USERNAME, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_TIP, new Object[0]), "name", user.getName(), null);
        ItemConfiguration nameConfiguration = new ItemConfiguration("name", user.getName());
        nameConfiguration.addValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_VALIDATOR, new Object[0]), Integer.valueOf(1), null));
        nameConfiguration.addValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_LENGTH, new Object[0]), null, Integer.valueOf(32)));
        nameConfiguration.addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_REGEXP, new Object[0]), "[a-zA-Z_][a-zA-Z0-9._-]*[$]?"));
        nameConfiguration.addValidator((Validator)new AbstractValidator<String>(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_NAME_EXISTS, new Object[0])){

            public ValidationResult apply(String value, ValueContext context) {
                Optional optional = UserView.this.userService.findBySAMAccountName(value.toString());
                return this.toResult(value, !optional.isPresent());
            }
        });
        if (this.secondaryDirectory) {
            nameConfiguration.disable();
        }
        name.setConfiguration(nameConfiguration);
        configuration.addProperty(name);
        OtcTextProperty desc = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]), null, "description", user.getDescription(), null);
        ItemConfiguration descConfig = new ItemConfiguration("description", user.getDescription());
        if (this.secondaryDirectory) {
            descConfig.disable();
        }
        desc.setConfiguration(descConfig);
        configuration.addProperty(desc);
        String pwdValue = user.getUserPassword() != null ? new String(user.getUserPassword()) : null;
        OtcPasswordProperty pwd = new OtcPasswordProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_LABEL, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_VALIDATOR_LENGTH, new Object[0]), "password", pwdValue);
        final ItemConfiguration pwdConfig = new ItemConfiguration("password", pwdValue);
        pwdConfig.addValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_VALIDATOR_LENGTH, new Object[0]), Integer.valueOf(1), null));
        if (this.secondaryDirectory) {
            pwdConfig.disable();
        }
        pwd.setConfiguration(pwdConfig);
        configuration.addProperty(pwd);
        OtcPasswordProperty pwdRetype = new OtcPasswordProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_RETYPE_LABEL, new Object[0]), null, "passwordRetype", pwdValue);
        ItemConfiguration pwdRetypeConfig = new ItemConfiguration("passwordRetype", pwdValue);
        pwdRetypeConfig.addValidator((Validator)new AbstractValidator<String>(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_RETYPE_VALIDATOR, new Object[0])){

            public ValidationResult apply(String value, ValueContext context) {
                return this.toResult(value, pwdConfig.getValue() != null && pwdConfig.getValue().equals(value));
            }
        });
        if (this.secondaryDirectory) {
            pwdRetypeConfig.disable();
        }
        pwdRetype.setConfiguration(pwdRetypeConfig);
        configuration.addProperty(pwdRetype);
        return configuration;
    }

    @Override
    protected User newProfile() {
        return new User();
    }

    @Override
    public User getFreshProfile(String name) {
        return (User)this.userService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(User profile, Class<D> clazz) {
        if (clazz == UserGroup.class) {
            return profile.getUserGroups();
        }
        if (clazz == ApplicationGroup.class) {
            return profile.getApplicationGroups();
        }
        if (clazz == Printer.class) {
            return profile.getPrinters();
        }
        if (clazz == Application.class) {
            return profile.getApplications();
        }
        return Collections.emptySet();
    }

    @Override
    public void save(User profile) {
        if (!this.secondaryDirectory) {
            LOGGER.info("Save: " + profile);
            this.userService.save((DirectoryObject)profile);
            Audit.logSave((DirectoryObject)profile);
        }
    }

    @Override
    public void showProfileMetadata(User profile) {
        ProfilePanel profilePanel = this.createUserProfilePanel(profile, true);
        this.showProfileMetadataPanel(profilePanel);
    }

    protected ProfilePanel createUserProfilePanel(User profile, boolean userIsNew) {
        OtcPropertyGroup propertyGroup = this.createUserMetadataPropertyGroup(profile);
        if (!userIsNew) {
            propertyGroup.getProperty("name").ifPresent(otcProperty -> {
                OtcTextProperty name = (OtcTextProperty)otcProperty;
                name.getConfiguration().getValidators().clear();
                name.getConfiguration().disable();
            });
        }
        String panelCaption = userIsNew ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_PROFILE_HEADER, new Object[0]) : profile.getName();
        ProfilePanel profilePanel = new ProfilePanel(panelCaption, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER, new Object[0]), User.class);
        DirectoryObjectPanelPresenter ppp = new DirectoryObjectPanelPresenter(this, profilePanel, (DirectoryObject)profile);
        ppp.setItemGroups(Arrays.asList(propertyGroup, new OtcPropertyGroup()));
        if (userIsNew) {
            ppp.hideCopyButton();
            ppp.hideDeleteButton();
        }
        if (this.secondaryDirectory) {
            ppp.setDisabledMode();
            ppp.hideCopyButton();
            ppp.hideDeleteButton();
        } else {
            ppp.onValuesWritten(profilePanel1 -> ppp.getItemGroupPanels().forEach(igp -> {
                igp.propertyComponents().forEach(propertyComponent -> {
                    OtcProperty bean = (OtcProperty)propertyComponent.getBinder().getBean();
                    String key = bean.getKey();
                    String value = bean.getConfiguration().getValue();
                    switch (key) {
                        case "name": {
                            profile.setName(value);
                            break;
                        }
                        case "description": {
                            profile.setDescription(value);
                            break;
                        }
                        case "password": {
                            profile.setUserPassword(value.getBytes());
                            break;
                        }
                        case "passwordRetype": {
                            profile.setVerifyPassword(value);
                        }
                    }
                });
                boolean success = this.saveProfile(profile, ppp);
                if (success) {
                    this.selectItem((DirectoryObject)profile);
                    if (userIsNew) {
                        this.navigateTo((DirectoryObject)profile);
                    }
                }
            }));
        }
        return profilePanel;
    }

    @Override
    public void showProfile(User profile) {
        String message = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME, new Object[]{""}).trim();
        boolean userIsNew = profile.getName().indexOf(message) == 0;
        ProfilePanel profilePanel = this.createUserProfilePanel(profile, userIsNew);
        ProfileReferencesPanel profileReferencesPanel = this.createReferencesPanel(profile);
        this.displayProfilePanel(profilePanel, profileReferencesPanel);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void showOverview() {
        super.showOverview(!this.secondaryDirectory);
        this.overviewCL.addComponent((Component)this.userGroupView.createOverviewItemlistPanel(this.userGroupView.getViewTitleKey(), this.userGroupView.getAllItems(), !this.secondaryDirectory).getPanel());
    }
}

