/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.openthinclient.web.thinclient.component.ItemButtonComponent;
import org.openthinclient.web.thinclient.model.Item;

public class ReferencesComponent
extends CssLayout {
    private CssLayout referenceLine;
    private Button referenceComponentCaption;
    private NavigableMap<String, ItemButtonComponent> itemComponents = new TreeMap<String, ItemButtonComponent>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, CssLayout> sublineComponents = new HashMap<String, CssLayout>();

    public ReferencesComponent(String labelText, boolean isReadOnly, boolean isReferenceStart) {
        this.addStyleName("referenceComponent");
        if (isReferenceStart) {
            this.addStyleName("reference-start");
        }
        this.referenceComponentCaption = new Button(labelText);
        this.referenceComponentCaption.addStyleNames(new String[]{"referenceComponentCaption"});
        this.referenceComponentCaption.addStyleName("borderless");
        this.referenceComponentCaption.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            this.referenceComponentCaption.setIcon((Resource)VaadinIcons.COG_O);
        }
        this.addComponent((Component)this.referenceComponentCaption);
        this.referenceLine = new CssLayout();
        this.referenceLine.addStyleName("referenceLine");
        this.addComponent((Component)this.referenceLine);
    }

    public ItemButtonComponent addItemComponent(Item item) {
        ItemButtonComponent buttonComponent = new ItemButtonComponent(item);
        this.itemComponents.put(item.getName(), buttonComponent);
        this.addComponentSorted(item.getName(), (Component)buttonComponent);
        return buttonComponent;
    }

    public void removeItemComponent(String name) {
        if (this.itemComponents.containsKey(name)) {
            this.referenceLine.removeComponent((Component)this.itemComponents.remove(name));
        }
    }

    public Button getMultiSelectPopupBtn() {
        return this.referenceComponentCaption;
    }

    public void addReferenceSublineComponents(String name, Component ... components) {
        this.addStyleName("has-subline-content");
        CssLayout referenceContentLine = new CssLayout();
        referenceContentLine.addComponents(components);
        referenceContentLine.setStyleName("referenceLine");
        referenceContentLine.addStyleName("subline-content");
        this.sublineComponents.put(name, referenceContentLine);
        this.addComponentSorted(name, (Component)referenceContentLine);
    }

    public void removeReferenceSublineComponent(String name) {
        if (this.sublineComponents.containsKey(name)) {
            this.referenceLine.removeComponent((Component)this.sublineComponents.remove(name));
        }
    }

    private void addComponentSorted(String name, Component component) {
        Map.Entry<String, ItemButtonComponent> nextItemEntry = this.itemComponents.higherEntry(name);
        if (nextItemEntry != null) {
            this.referenceLine.addComponent(component, this.referenceLine.getComponentIndex((Component)nextItemEntry.getValue()));
        } else {
            this.referenceLine.addComponent(component);
        }
    }
}

