/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openthinclient.web.thinclient.property.OtcProperty;

public class OtcPropertyGroup {
    private String label;
    private String tip;
    private List<OtcProperty> otcProperties = new ArrayList<OtcProperty>();
    private List<OtcPropertyGroup> groups = new ArrayList<OtcPropertyGroup>();

    public OtcPropertyGroup(String label, String tip) {
        this.label = label;
        this.tip = tip;
    }

    public OtcPropertyGroup() {
        new OtcPropertyGroup(null, null);
    }

    public List<OtcProperty> getOtcProperties() {
        return this.otcProperties;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTip() {
        return this.tip;
    }

    public List<OtcPropertyGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(OtcPropertyGroup group) {
        this.groups.add(group);
    }

    public void addProperty(OtcProperty property) {
        this.otcProperties.add(property);
    }

    public void removeProperty(String key) {
        this.otcProperties.stream().filter(otcProperty -> otcProperty.getKey().equals(key)).findFirst().ifPresent(otcProperty -> this.otcProperties.remove(otcProperty));
    }

    public Optional<OtcProperty> getProperty(String key) {
        return this.otcProperties.stream().filter(otcProperty -> otcProperty.getKey().equals(key)).findFirst();
    }

    public List<OtcPropertyGroup> getAllOtcPropertyGroups() {
        ArrayList<OtcPropertyGroup> all = new ArrayList<OtcPropertyGroup>(this.groups);
        this.groups.forEach(group -> all.addAll(group.getAllOtcPropertyGroups()));
        return all;
    }
}

