/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.openthinclient.sysreport.AbstractReportPackage;
import org.openthinclient.sysreport.SystemReport;

public class SystemReportPackage
extends AbstractReportPackage<SystemReport> {
    public static final String PATH_REPORTS = "tcos-reports/";
    private static final String PATH_LOGS = "logs/";
    private final Map<String, List<Path>> tcosReports = new HashMap<String, List<Path>>();
    private final List<Path> logfiles = new ArrayList<Path>();

    public SystemReportPackage(SystemReport report) {
        super(report, "system-report.json");
    }

    public void addReport(String macAddress, Path reportFile) {
        if (!Files.isRegularFile(reportFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Provided path does not point to a valid file: " + reportFile);
        }
        List paths = this.tcosReports.computeIfAbsent(macAddress, k -> new ArrayList());
        paths.add(reportFile);
    }

    public void addLogfile(Path logfile) {
        if (!Files.isRegularFile(logfile, new LinkOption[0])) {
            throw new IllegalArgumentException("Provided path does not point to a valid file: " + logfile);
        }
        this.logfiles.add(logfile);
    }

    @Override
    protected void writeAdditionalContents(ZipArchiveOutputStream zip, Instant creationTimestamp) throws IOException {
        this.writeTcosReports(zip, creationTimestamp);
        this.writeLogfiles(zip, creationTimestamp);
    }

    private void writeLogfiles(ZipArchiveOutputStream zip, Instant creationTimestamp) throws IOException {
        zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(PATH_LOGS));
        zip.closeArchiveEntry();
        for (Path logfile : this.logfiles) {
            this.writeLogfile(zip, logfile, creationTimestamp);
        }
    }

    private void writeLogfile(ZipArchiveOutputStream zip, Path logfile, Instant creationTimestamp) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(PATH_LOGS + logfile.getFileName().toString());
        entry.setCreationTime(Files.getLastModifiedTime(logfile, new LinkOption[0]));
        zip.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(logfile, (OutputStream)zip);
        zip.closeArchiveEntry();
    }

    private void writeTcosReports(ZipArchiveOutputStream zip, Instant creationTimestamp) throws IOException {
        zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(PATH_REPORTS));
        zip.closeArchiveEntry();
        for (Map.Entry<String, List<Path>> e : this.tcosReports.entrySet()) {
            this.writeTcosReports(zip, e.getKey(), e.getValue(), creationTimestamp);
        }
    }

    private void writeTcosReports(ZipArchiveOutputStream zip, String clientMacAddress, List<Path> tcosReports, Instant creationTimestamp) throws IOException {
        zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(PATH_REPORTS + clientMacAddress + "/"));
        zip.closeArchiveEntry();
        for (Path tcosReport : tcosReports) {
            this.writeTcosReport(zip, clientMacAddress, tcosReport, creationTimestamp);
        }
    }

    private void writeTcosReport(ZipArchiveOutputStream zip, String clientMacAddress, Path tcosReport, Instant creationTimestamp) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(PATH_REPORTS + clientMacAddress + "/" + tcosReport.getFileName().toString());
        entry.setCreationTime(Files.getLastModifiedTime(tcosReport, new LinkOption[0]));
        zip.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(tcosReport, (OutputStream)zip);
        zip.closeArchiveEntry();
    }
}

