/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.util;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;

public final class SecurityExceptionUtils {
    private SecurityExceptionUtils() {
    }

    public static boolean isAccessDeniedException(Throwable throwable) {
        return SecurityExceptionUtils.hasExceptionOfTypeInChain(AccessDeniedException.class, throwable);
    }

    public static boolean isAuthenticationException(Throwable throwable) {
        return SecurityExceptionUtils.hasExceptionOfTypeInChain(AuthenticationException.class, throwable);
    }

    private static boolean hasExceptionOfTypeInChain(Class<? extends Throwable> type, Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (type.isInstance(throwable)) {
            return true;
        }
        return SecurityExceptionUtils.hasExceptionOfTypeInChain(type, throwable.getCause());
    }
}

