/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.web;

import com.vaadin.ui.UI;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.UrlUtils;
import org.vaadin.spring.security.web.VaadinRedirectStrategy;

public class DefaultVaadinRedirectStrategy
implements VaadinRedirectStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVaadinRedirectStrategy.class);
    private boolean contextRelative;
    @Autowired
    ServletContext servletContext;

    @Override
    public void sendRedirect(String url) {
        String redirectUrl = this.calculateRedirectUrl(this.servletContext.getContextPath(), url);
        LOGGER.debug("Redirecting to [" + redirectUrl + "]");
        UI.getCurrent().getPage().setLocation(redirectUrl);
    }

    private String calculateRedirectUrl(String contextPath, String url) {
        if (!UrlUtils.isAbsoluteUrl((String)url)) {
            if (this.contextRelative) {
                return url;
            }
            return contextPath + url;
        }
        if (!this.contextRelative) {
            return url;
        }
        url = url.substring(url.lastIndexOf("://") + 3);
        if ((url = url.substring(url.indexOf(contextPath) + contextPath.length())).length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    public void setContextRelative(boolean useRelativeContext) {
        this.contextRelative = useRelativeContext;
    }
}

