/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.directory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.openthinclient.common.directory.Directory;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.TypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPDirectory
implements Directory {
    private static final Logger logger = LoggerFactory.getLogger(LDAPDirectory.class);
    public static final String REALM_RDN = "ou=RealmConfiguration";
    private final Mapping mapping;
    private final Realm realm;
    private static Set<Class> secondaryClasses = new HashSet<Class>();
    private static final Map<String, Mapping> mappingCache = Collections.synchronizedMap(new HashMap());

    private static Mapping loadLDAPMapping(String descriptorName) throws IOException, MappingException, ValidationException, MarshalException, DirectoryException {
        Mapping m = mappingCache.get(descriptorName);
        if (null == m) {
            InputStream is = LDAPDirectory.class.getResourceAsStream(descriptorName + ".xml");
            if (null == is) {
                throw new DirectoryException("Can't load mapping of type " + descriptorName);
            }
            m = Mapping.load(is);
            m.initialize();
            mappingCache.put(descriptorName, m);
        }
        return m;
    }

    private LDAPDirectory(Mapping mapping, Realm realm) {
        this.mapping = mapping;
        this.realm = realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Realm> listRealms(LDAPConnectionDescriptor lcd) throws DirectoryException {
        DirectoryFacade df = lcd.createDirectoryFacade();
        Mapping rootMapping = LDAPDirectory.loadMapping(df);
        try {
            Set<Realm> realms = rootMapping.list(Realm.class);
            for (Realm realm : realms) {
                String realmDN = realm.getDn();
                realmDN = realmDN.replaceFirst("^[^,]+,", "");
                LDAPConnectionDescriptor d = new LDAPConnectionDescriptor(lcd);
                d.setBaseDN(realmDN);
                realm.setConnectionDescriptor(d);
                rootMapping.refresh(realm);
            }
            Set<Realm> set = realms;
            rootMapping.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                rootMapping.close();
                throw throwable;
            }
            catch (DirectoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DirectoryException("Can't init mapping", e);
            }
        }
    }

    public static Set<Realm> findAllRealms(LDAPConnectionDescriptor lcd) throws DirectoryException {
        try {
            HashSet<Realm> realms = new HashSet<Realm>();
            List<String> partitions = LDAPDirectory.listPartitions(lcd);
            for (String partition : partitions) {
                LDAPConnectionDescriptor d = new LDAPConnectionDescriptor(lcd);
                d.setBaseDN(partition);
                try {
                    realms.addAll(LDAPDirectory.listRealms(d));
                }
                catch (DirectoryException e) {
                    logger.error("Can't list realms for partition " + partition + ". Skipping it.", (Throwable)e);
                }
            }
            return realms;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't init mapping", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listPartitions(LDAPConnectionDescriptor lcd) throws NamingException {
        ArrayList<String> partitions = new ArrayList<String>();
        try {
            LdapContext ctx = lcd.createDirectoryFacade().createDirContext();
            try {
                Attributes a = ctx.getAttributes("", new String[]{"namingContexts"});
                Attribute namingContexts = a.get("namingContexts");
                if (null == namingContexts) {
                    throw new NamingException("Directory doesn't supply a list of partitions.");
                }
                NamingEnumeration<?> allAttributes = namingContexts.getAll();
                while (allAttributes.hasMore()) {
                    partitions.add(allAttributes.next().toString());
                }
            }
            finally {
                if (null != ctx) {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingException("Can't open connection: " + e);
        }
        return partitions;
    }

    private static Mapping loadMapping(DirectoryFacade df) throws DirectoryException, ValidationException, MarshalException, IOException, MappingException, NamingException {
        Mapping mapping = new Mapping(LDAPDirectory.loadLDAPMapping(df.guessDirectoryType().toString()));
        mapping.setDirectoryFacade(df);
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LDAPDirectory openRealm(Realm realm) throws DirectoryException {
        LDAPConnectionDescriptor lcd = realm.getConnectionDescriptor();
        LDAPDirectory.assertBaseDNReachable(lcd);
        DirectoryFacade df = lcd.createDirectoryFacade();
        Mapping rootMapping = LDAPDirectory.loadMapping(df);
        rootMapping.setDirectoryFacade(df);
        rootMapping.refresh(realm);
        String version = realm.getValue("UserGroupSettings.DirectoryVersion");
        String secondaryUrlString = realm.getValue("Directory.Secondary.LDAPURLs");
        if (null == version) {
            version = "";
        }
        secondaryClasses = new HashSet<Class>();
        if (version.equals("secondary") && null != secondaryUrlString && null != secondaryUrlString) {
            LDAPConnectionDescriptor secLcd = realm.createSecondaryConnectionDescriptor();
            try {
                LDAPDirectory.assertBaseDNReachable(secLcd);
                DirectoryFacade secondaryDF = secLcd.createDirectoryFacade();
                Mapping secondaryMapping = LDAPDirectory.loadMapping(secondaryDF);
                LDAPDirectory.copyTypeMapping(rootMapping, secondaryMapping, User.class, UserGroup.class);
                secondaryClasses.add(User.class);
                secondaryClasses.add(UserGroup.class);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                rootMapping.refresh(realm);
            }
        }
        try {
            LDAPDirectory lDAPDirectory = new LDAPDirectory(rootMapping, realm);
            rootMapping.close();
            return lDAPDirectory;
        }
        catch (Throwable throwable) {
            try {
                rootMapping.close();
                throw throwable;
            }
            catch (DirectoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DirectoryException("Can't init directory", e);
            }
        }
    }

    private static void copyTypeMapping(Mapping rootMapping, Mapping secondaryMapping, Class ... type) {
        LinkedList<TypeMapping> relocated = new LinkedList<TypeMapping>();
        for (Class c : type) {
            TypeMapping typeMapping = secondaryMapping.getTypes().get(c);
            rootMapping.add(typeMapping);
            relocated.add(typeMapping);
        }
        for (TypeMapping typeMapping : relocated) {
            typeMapping.initPostLoad();
        }
    }

    public static void assertBaseDNReachable(LDAPConnectionDescriptor lcd) throws NamingException, DirectoryException {
        try (LdapContext ctx = lcd.createDirectoryFacade().createDirContext();){
            ctx.getAttributes("");
        }
    }

    public static LDAPDirectory openEnv(LDAPConnectionDescriptor lcd) throws DirectoryException {
        try {
            return new LDAPDirectory(LDAPDirectory.loadMapping(lcd.createDirectoryFacade()), null);
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't init directory", e);
        }
    }

    @Override
    public <T> T create(Class<T> type) throws DirectoryException {
        this.assertInitialized();
        return this.mapping.create(type);
    }

    @Override
    public boolean delete(Object object) throws DirectoryException {
        this.assertInitialized();
        return this.mapping.delete(object);
    }

    @Override
    public <T> Set<T> list(Class<T> type) throws DirectoryException {
        this.assertInitialized();
        Set<T> list = this.mapping.list(type);
        this.associateWithRealm(list);
        return list;
    }

    private <T> void associateWithRealm(Set<T> list) {
        for (T t : list) {
            if (!(t instanceof DirectoryObject)) continue;
            ((DirectoryObject)t).setRealm(this.realm);
        }
    }

    public <T> Set<T> list(Class<T> type, Filter filter, TypeMapping.SearchScope scope) throws DirectoryException {
        this.assertInitialized();
        Set<T> list = this.mapping.list(type, filter, null, scope);
        this.associateWithRealm(list);
        return list;
    }

    public <T> Set<T> list(Class<T> type, Filter filter, String baseDN, TypeMapping.SearchScope scope) throws DirectoryException {
        this.assertInitialized();
        Set<T> list = this.mapping.list(type, filter, baseDN, scope);
        this.associateWithRealm(list);
        return list;
    }

    public <T extends DirectoryObject> Set<String> query(Class<T> type, Filter filter, String baseDN, TypeMapping.SearchScope scope) throws DirectoryException {
        this.assertInitialized();
        return this.mapping.query(type, filter, baseDN, scope);
    }

    public <T> T load(Class<T> type, String dn) throws DirectoryException {
        this.assertInitialized();
        T load = this.mapping.load(type, dn, false);
        return load;
    }

    public <T> T load(Class<T> type, String dn, boolean noCache) throws DirectoryException {
        this.assertInitialized();
        T load = this.mapping.load(type, dn, noCache);
        if (load instanceof DirectoryObject) {
            ((DirectoryObject)load).setRealm(this.realm);
        }
        return load;
    }

    @Override
    public synchronized void save(Object object) throws DirectoryException {
        this.assertInitialized();
        this.mapping.save(object, null);
        this.mapping.refresh(object);
    }

    public void save(Object object, String baseDN) throws DirectoryException {
        this.assertInitialized();
        this.mapping.save(object, baseDN);
        this.mapping.refresh(object);
    }

    private void assertInitialized() {
        if (null == this.mapping) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public void refresh(Object o) throws DirectoryException {
        this.assertInitialized();
        this.mapping.refresh(o);
        if (o instanceof DirectoryObject) {
            ((DirectoryObject)o).setRealm(this.realm);
        }
    }

    @Deprecated
    public Mapping getMapping() {
        return this.mapping;
    }

    @Deprecated
    public static String idToUpperCase(String member) {
        String ret = "";
        member = member.replace("\\,", "#%COMMA%#");
        String[] s = member.split(",");
        for (int i = 0; s.length > i; ++i) {
            if (s[i].startsWith("cn=")) {
                s[i] = s[i].replaceFirst("cn=", "CN=");
            }
            if (s[i].startsWith("dc=")) {
                s[i] = s[i].replaceFirst("dc=", "DC=");
            }
            if (s[i].startsWith("ou=")) {
                s[i] = s[i].replaceFirst("ou=", "OU=");
            }
            if (s[i].startsWith("l=")) {
                s[i] = s[i].replaceFirst("l=", "L=");
            }
            ret = ret + s[i].trim();
            if (i + 1 >= s.length) continue;
            ret = ret + ",";
        }
        ret = ret.replace("#%COMMA%#", "\\,");
        ret = ret.trim();
        return ret;
    }

    @Deprecated
    public static boolean isMutable(Class currentClass) {
        for (Class secClass : secondaryClasses) {
            if (currentClass != secClass) continue;
            return false;
        }
        return true;
    }
}

