/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;

public class ClientMetaData
extends Profile {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    private String ipHostNumber;
    private String macAddress;

    public String getIpHostNumber() {
        if (null == this.ipHostNumber) {
            return "0.0.0.0";
        }
        return this.ipHostNumber;
    }

    public void setIpHostNumber(String ipHostNumber) {
        String oldIpAddress = this.ipHostNumber;
        this.ipHostNumber = ipHostNumber;
        this.firePropertyChange("ipHostNumber", oldIpAddress, ipHostNumber);
    }

    @Override
    public Schema getSchema(Realm realm) throws SchemaLoadingException {
        if (null == this.schema) {
            this.schema = new Client().getSchema(realm);
        }
        return this.schema;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ClientMetaData name=").append(this.getName()).append(", description=").append(this.getDescription()).append(", ip=").append(this.ipHostNumber);
        return sb.toString();
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        String oldMacAddress = this.macAddress;
        this.macAddress = macAddress.toLowerCase();
        this.firePropertyChange("macAddress", oldMacAddress, macAddress);
    }
}

