/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import java.util.Collections;
import java.util.Set;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLDAPRealmService
implements RealmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLDAPRealmService.class);
    private final SchemaProvider schemaProvider;
    private final LDAPConnectionDescriptor lcd;
    private volatile Set<Realm> realms;

    public DefaultLDAPRealmService(SchemaProvider schemaProvider, LDAPConnectionDescriptor lcd) {
        this.schemaProvider = schemaProvider;
        this.lcd = lcd;
    }

    @Override
    public Realm getDefaultRealm() {
        Set<Realm> all = this.findAllRealms();
        if (all.size() > 0) {
            return all.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Realm> findAllRealms() {
        if (this.realms == null) {
            DefaultLDAPRealmService defaultLDAPRealmService = this;
            synchronized (defaultLDAPRealmService) {
                if (this.realms == null) {
                    this.reload();
                }
            }
        }
        return Collections.unmodifiableSet(this.realms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        DefaultLDAPRealmService defaultLDAPRealmService = this;
        synchronized (defaultLDAPRealmService) {
            try {
                Set<Realm> realms = LDAPDirectory.findAllRealms(this.lcd);
                for (Realm realm : realms) {
                    realm.setSchemaProvider(this.schemaProvider);
                    try {
                        Schema schema = this.schemaProvider.getSchema(Realm.class, null);
                        realm.setSchema(schema);
                    }
                    catch (SchemaLoadingException e) {
                        LOGGER.error("Failed to load realm schema definition. Trying to proceed.", (Throwable)e);
                    }
                }
                this.realms = realms;
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

