/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.service.AbstractLDAPService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.TypeMapping;

public class DefaultLDAPUnrecognizedClientService
extends AbstractLDAPService<UnrecognizedClient>
implements UnrecognizedClientService {
    public DefaultLDAPUnrecognizedClientService(RealmService realmService) {
        super(UnrecognizedClient.class, realmService);
    }

    @Override
    public Set<UnrecognizedClient> findByHwAddress(String hwAddressString) {
        return this.withAllReams(realm -> {
            try {
                return realm.getDirectory().list(UnrecognizedClient.class, new Filter("(&(macAddress={0})(!(l=*)))", hwAddressString), TypeMapping.SearchScope.SUBTREE).stream();
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public Set<UnrecognizedClient> findAll() {
        return this.withAllReams(realm -> {
            try {
                return realm.getDirectory().list(UnrecognizedClient.class).stream();
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public UnrecognizedClient add(UnrecognizedClient unrecognizedClient) {
        Realm realm = this.realmService.getDefaultRealm();
        try {
            realm.getDirectory().save(unrecognizedClient);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
        return unrecognizedClient;
    }

    @Override
    public List<String> getLastSeenMACs(long amount) {
        return this.withAllReams(realm -> {
            try {
                return realm.getDirectory().list(UnrecognizedClient.class).stream().sorted(Comparator.comparing(DirectoryObject::getDescription, String::compareTo).reversed()).limit(amount).map(uc -> uc.getMacAddress());
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

